/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.function.Function;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestPreviewVO;
import org.cyclos.model.banking.transactions.ChangePaymentRequestExpirationDateDTO;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.RequestPaymentData;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.banking.PaymentRequestService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.PaymentRequestsApi;
import org.cyclos.web.rest.helpers.PaymentRequestsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.AcceptOrReschedulePaymentRequest;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.PaymentRequestPreview;
import org.cyclos.web.rest.model.SendPaymentRequest;
import org.cyclos.web.rest.model.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentRequestsApiImpl
extends BaseApiImpl {
    @Autowired
    private PaymentRequestService paymentRequestService;
    @Autowired
    private PaymentRequestsApiHelper paymentRequestsApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;

    public ResponseEntity<Transaction> acceptPaymentRequest(PaymentRequestsApi.AcceptPaymentRequestParams acceptPaymentRequestParams) {
        return this.acceptOrReschedulePaymentRequest(acceptPaymentRequestParams.key, acceptPaymentRequestParams.confirmationPassword, acceptPaymentRequestParams.acceptOrReschedulePaymentRequest, acceptPaymentRequestParams.fields, arg_0 -> ((PaymentRequestService)this.paymentRequestService).accept(arg_0));
    }

    public ResponseEntity<Void> cancelPaymentRequest(String string, String string2, String string3) {
        PaymentRequestActionDTO paymentRequestActionDTO = this.paymentRequestsApiHelper.toPaymentRequestActionDTO(string, string3, string2);
        this.paymentRequestService.cancel(paymentRequestActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> changePaymentRequestExpirationDate(PaymentRequestsApi.ChangePaymentRequestExpirationDateParams changePaymentRequestExpirationDateParams) {
        ChangePaymentRequestExpirationDateDTO changePaymentRequestExpirationDateDTO = this.paymentRequestsApiHelper.toChangePaymentRequestExpirationDateDTO(changePaymentRequestExpirationDateParams.key, changePaymentRequestExpirationDateParams.confirmationPassword, changePaymentRequestExpirationDateParams.changePaymentRequestExpirationDate);
        this.paymentRequestService.changeExpirationDate(changePaymentRequestExpirationDateDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DataForTransaction> dataForSendPaymentRequest(PaymentRequestsApi.DataForSendPaymentRequestParams dataForSendPaymentRequestParams) {
        InternalAccountOwner internalAccountOwner = ModelHelper.accountOwner((String)dataForSendPaymentRequestParams.owner);
        InternalAccountOwner internalAccountOwner2 = ModelHelper.accountOwner((String)dataForSendPaymentRequestParams.to);
        TransferTypeVO transferTypeVO = (TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)dataForSendPaymentRequestParams.type);
        RequestPaymentData requestPaymentData = this.paymentRequestService.getRequestData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
        DataForTransaction dataForTransaction = this.transactionsApiHelper.toDataForTransaction(requestPaymentData);
        return this.ok(dataForTransaction);
    }

    public ResponseEntity<PaymentRequestPreview> previewPaymentRequest(String string, List<String> list) {
        AcceptPaymentRequestPreviewVO acceptPaymentRequestPreviewVO = this.paymentRequestService.previewAccept((PaymentRequestVO)ModelHelper.voFromString(PaymentRequestVO.class, (String)string));
        PaymentRequestPreview paymentRequestPreview = this.paymentRequestsApiHelper.toPaymentRequestPreview(acceptPaymentRequestPreviewVO);
        return this.ok(paymentRequestPreview);
    }

    public ResponseEntity<Void> rejectPaymentRequest(String string, String string2, String string3) {
        PaymentRequestActionDTO paymentRequestActionDTO = this.paymentRequestsApiHelper.toPaymentRequestActionDTO(string, string3, string2);
        this.paymentRequestService.deny(paymentRequestActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Transaction> reschedulePaymentRequest(PaymentRequestsApi.ReschedulePaymentRequestParams reschedulePaymentRequestParams) {
        return this.acceptOrReschedulePaymentRequest(reschedulePaymentRequestParams.key, reschedulePaymentRequestParams.confirmationPassword, reschedulePaymentRequestParams.acceptOrReschedulePaymentRequest, reschedulePaymentRequestParams.fields, arg_0 -> ((PaymentRequestService)this.paymentRequestService).reschedule(arg_0));
    }

    public ResponseEntity<Transaction> sendPaymentRequest(String string, SendPaymentRequest sendPaymentRequest, List<String> list) {
        SendPaymentRequestDTO sendPaymentRequestDTO = this.paymentRequestsApiHelper.toSendPaymentRequestDTO(string, sendPaymentRequest);
        PaymentRequestVO paymentRequestVO = this.paymentRequestService.send(sendPaymentRequestDTO);
        return this.transactionsApiHelper.toResponseTransaction((TransactionVO)paymentRequestVO);
    }

    private ResponseEntity acceptOrReschedulePaymentRequest(String string, String string2, AcceptOrReschedulePaymentRequest acceptOrReschedulePaymentRequest, List<String> list, Function<AcceptPaymentRequestDTO, PaymentRequestVO> function) {
        AcceptPaymentRequestDTO acceptPaymentRequestDTO = this.paymentRequestsApiHelper.toAcceptPaymentRequestDTO(string, string2, acceptOrReschedulePaymentRequest);
        PaymentRequestVO paymentRequestVO = function.apply(acceptPaymentRequestDTO);
        if (paymentRequestVO.getStatus() == PaymentRequestStatus.PROCESSED) {
            return this.transactionsApiHelper.toResponseTransaction((TransactionVO)paymentRequestVO.getTransaction());
        }
        return ResponseEntity.noContent().build();
    }
}

