/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.PasswordsApiImpl;
import org.cyclos.web.rest.model.ChangePassword;
import org.cyclos.web.rest.model.DataForUserPasswords;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PasswordStatusAndActions;
import org.cyclos.web.rest.model.PasswordStatusAndType;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.SetSecurityAnswer;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PasswordsApi {
    @Autowired
    private PasswordsApiImpl impl;
    public static final String ALLOW_GENERATION = "/{user}/passwords/{type}/allow-generation";
    public static final String CHANGE_GENERATED = "/passwords/{type}/change-generated";
    public static final String CHANGE_PASSWORD = "/{user}/passwords/{type}/change";
    public static final String DISABLE_PASSWORD = "/{user}/passwords/{type}/disable";
    public static final String ENABLE_PASSWORD = "/{user}/passwords/{type}/enable";
    public static final String GENERATE_PASSWORD = "/passwords/{type}/generate";
    public static final String GET_USER_PASSWORDS_DATA = "/{user}/passwords/{type}";
    public static final String GET_USER_PASSWORDS_LIST_DATA = "/{user}/passwords/list-data";
    public static final String LIST_USER_PASSWORDS = "/{user}/passwords";
    public static final String RESET_AND_SEND_PASSWORD = "/{user}/passwords/{type}/reset-and-send";
    public static final String RESET_GENERATED_PASSWORD = "/{user}/passwords/{type}/reset-generated";
    public static final String RESET_USER_SECURITY_ANSWER = "/{user}/security-answer";
    public static final String SET_SECURITY_ANSWER = "/security-answer";
    public static final String UNBLOCK_PASSWORD = "/{user}/passwords/{type}/unblock";

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/allow-generation"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> allowGeneration(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/allow-generation");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.allowGeneration(string, string2);
    }

    @RequestMapping(value={"/api/passwords/{type}/change-generated"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> changeGenerated(@PathVariable(value="type") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /passwords/{type}/change-generated");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.changeGenerated(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/change"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> changePassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, @RequestBody(required=true) ChangePassword changePassword, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/change");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.changePassword(string, string2, changePassword);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/disable"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> disablePassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/disable");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.disablePassword(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/enable"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> enablePassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/enable");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.enablePassword(string, string2);
    }

    @RequestMapping(value={"/api/passwords/{type}/generate"}, produces={"text/plain", "application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> generatePassword(@PathVariable(value="type") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /passwords/{type}/generate");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.generatePassword(string);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordStatusAndActions> getUserPasswordsData(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/passwords/{type}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserPasswordsData(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForUserPasswords> getUserPasswordsListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/passwords/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserPasswordsListData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PasswordStatusAndType>> listUserPasswords(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/passwords");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listUserPasswords(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/reset-and-send"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> resetAndSendPassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, @RequestParam(value="sendMediums", required=false) List<SendMediumEnum> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/reset-and-send");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resetAndSendPassword(string, string2, list);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/reset-generated"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> resetGeneratedPassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/reset-generated");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resetGeneratedPassword(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/security-answer"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> resetUserSecurityAnswer(@PathVariable(value="user") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /{user}/security-answer");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resetUserSecurityAnswer(string);
    }

    @RequestMapping(value={"/api/security-answer"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setSecurityAnswer(@RequestBody(required=true) SetSecurityAnswer setSecurityAnswer, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /security-answer");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setSecurityAnswer(setSecurityAnswer);
    }

    @RequestMapping(value={"/api/{user:.*}/passwords/{type}/unblock"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> unblockPassword(@PathVariable(value="user") String string, @PathVariable(value="type") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/passwords/{type}/unblock");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.unblockPassword(string, string2);
    }
}

