/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.OperatorGroupsApiImpl;
import org.cyclos.web.rest.model.EntityReference;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.OperatorGroupDataForEdit;
import org.cyclos.web.rest.model.OperatorGroupDataForNew;
import org.cyclos.web.rest.model.OperatorGroupEdit;
import org.cyclos.web.rest.model.OperatorGroupNew;
import org.cyclos.web.rest.model.OperatorGroupView;
import org.cyclos.web.rest.model.UserOperatorGroupsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class OperatorGroupsApi {
    @Autowired
    private OperatorGroupsApiImpl impl;
    public static final String CREATE_OPERATOR_GROUP = "/{user}/operator-groups";
    public static final String DELETE_OPERATOR_GROUP = "/operator-groups/{id}";
    public static final String GET_OPERATOR_GROUP_DATA_FOR_EDIT = "/operator-groups/{id}/data-for-edit";
    public static final String GET_OPERATOR_GROUP_DATA_FOR_NEW = "/{user}/operator-groups/data-for-new";
    public static final String GET_USER_OPERATOR_GROUPS_LIST_DATA = "/{user}/operator-groups/list-data";
    public static final String LIST_OPERATOR_GROUPS_BY_USER = "/{user}/operator-groups";
    public static final String UPDATE_OPERATOR_GROUP = "/operator-groups/{id}";
    public static final String VIEW_OPERATOR_GROUP = "/operator-groups/{id}";

    @RequestMapping(value={"/api/{user:.*}/operator-groups"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createOperatorGroup(@PathVariable(value="user") String string, @RequestBody(required=true) OperatorGroupNew operatorGroupNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/operator-groups");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createOperatorGroup(string, operatorGroupNew);
    }

    @RequestMapping(value={"/api/operator-groups/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteOperatorGroup(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /operator-groups/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteOperatorGroup(string);
    }

    @RequestMapping(value={"/api/operator-groups/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperatorGroupDataForEdit> getOperatorGroupDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /operator-groups/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOperatorGroupDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/operator-groups/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperatorGroupDataForNew> getOperatorGroupDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operator-groups/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOperatorGroupDataForNew(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/operator-groups/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserOperatorGroupsListData> getUserOperatorGroupsListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operator-groups/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserOperatorGroupsListData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/operator-groups"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<EntityReference>> listOperatorGroupsByUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/operator-groups");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperatorGroupsByUser(string, list);
    }

    @RequestMapping(value={"/api/operator-groups/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateOperatorGroup(@PathVariable(value="id") String string, @RequestBody(required=true) OperatorGroupEdit operatorGroupEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /operator-groups/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateOperatorGroup(string, operatorGroupEdit);
    }

    @RequestMapping(value={"/api/operator-groups/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperatorGroupView> viewOperatorGroup(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /operator-groups/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewOperatorGroup(string, list);
    }
}

