/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.RunCustomOperationDTO;
import org.cyclos.model.system.operations.RunCustomOperationData;
import org.cyclos.model.system.operations.RunCustomOperationDataParams;
import org.cyclos.model.system.operations.RunCustomOperationResult;
import org.cyclos.model.system.operations.RunExternalRedirectCallbackParams;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.contacts.ContactVO;
import org.cyclos.model.users.records.RecordVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.system.CustomOperationService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.OperationsApi;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.Operation;
import org.cyclos.web.rest.model.OperationDataForRun;
import org.cyclos.web.rest.model.OperationResultTypeEnum;
import org.cyclos.web.rest.model.OperationScopeEnum;
import org.cyclos.web.rest.model.RunOperation;
import org.cyclos.web.rest.model.RunOperationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class OperationsApiImpl
extends BaseApiImpl {
    @Autowired
    private CustomOperationService customOperationService;
    @Autowired
    private OperationsApiHelper operationsApiHelper;

    public ResponseEntity<OperationDataForRun> getAdOperationDataForRun(String string, String string2, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.ADVERTISEMENT, string2, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getContactInfoOperationDataForRun(String string, String string2, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.CONTACT_INFO, string2, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getContactOperationDataForRun(String string, String string2, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.CONTACT, string2, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getMenuOperationDataForRun(String string, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.MENU, null, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getOperationDataForRun(String string, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(null, string, null));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getOwnerOperationDataForRun(String string, String string2, List<String> list) {
        boolean bl = this.apiHelper.isSystem(string);
        RunCustomOperationDataParams runCustomOperationDataParams = this.operationsApiHelper.toRunCustomOperationDataParams(bl ? null : CustomOperationScope.USER, string2, string);
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(runCustomOperationDataParams);
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getRecordOperationDataForRun(String string, String string2, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.RECORD, string2, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<OperationDataForRun> getTransferOperationDataForRun(String string, String string2, List<String> list) {
        RunCustomOperationData runCustomOperationData = this.customOperationService.getRunData(this.operationsApiHelper.toRunCustomOperationDataParams(CustomOperationScope.TRANSFER, string2, string));
        OperationDataForRun operationDataForRun = this.operationsApiHelper.toOperationDataForRun(runCustomOperationData);
        return this.ok(operationDataForRun);
    }

    public ResponseEntity<List<Operation>> listOperationsByAd(String string, List<String> list) {
        List list2 = this.customOperationService.getRunnableOperationsForAd((BasicAdVO)ModelHelper.voFromString(BasicAdVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<Operation>> listOperationsByContact(String string, List<String> list) {
        List list2 = this.customOperationService.getRunnableOperationsForContact((ContactVO)ModelHelper.voFromString(ContactVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<Operation>> listOperationsByContactInfo(String string, List<String> list) {
        List list2 = this.customOperationService.getRunnableOperationsForContactInfo((ContactInfoVO)ModelHelper.voFromString(ContactInfoVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<Operation>> listOperationsByOwner(String string, List<String> list) {
        List list2 = this.apiHelper.isSystem(string) ? this.customOperationService.getRunnableOperationsForSystem() : this.customOperationService.getRunnableOperationsForUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<Operation>> listOperationsByRecord(String string, List<String> list) {
        List list2 = this.customOperationService.getRunnableOperationsForRecord((RecordVO)ModelHelper.voFromString(RecordVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<List<Operation>> listOperationsByTransfer(String string, List<String> list) {
        List list2 = this.customOperationService.getRunnableOperationsForTransfer((TransferVO)ModelHelper.voFromString(TransferVO.class, (String)string));
        List list3 = list2.stream().map(this.operationsApiHelper::toOperation).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<RunOperationResult> runAdOperation(OperationsApi.RunAdOperationParams runAdOperationParams) throws IOException {
        return this.doRun(OperationScopeEnum.ADVERTISEMENT, runAdOperationParams.operation, runAdOperationParams.ad, runAdOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runAdOperationWithUpload(OperationsApi.RunAdOperationWithUploadParams runAdOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.ADVERTISEMENT, runAdOperationWithUploadParams.operation, runAdOperationWithUploadParams.ad, runAdOperationWithUploadParams.params, runAdOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runContactInfoOperation(OperationsApi.RunContactInfoOperationParams runContactInfoOperationParams) throws IOException {
        return this.doRun(OperationScopeEnum.CONTACT_INFO, runContactInfoOperationParams.operation, runContactInfoOperationParams.id, runContactInfoOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runContactInfoOperationWithUpload(OperationsApi.RunContactInfoOperationWithUploadParams runContactInfoOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.CONTACT_INFO, runContactInfoOperationWithUploadParams.operation, runContactInfoOperationWithUploadParams.id, runContactInfoOperationWithUploadParams.params, runContactInfoOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runContactOperation(OperationsApi.RunContactOperationParams runContactOperationParams) throws IOException {
        return this.doRun(OperationScopeEnum.CONTACT, runContactOperationParams.operation, runContactOperationParams.id, runContactOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runContactOperationWithUpload(OperationsApi.RunContactOperationWithUploadParams runContactOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.CONTACT, runContactOperationWithUploadParams.operation, runContactOperationWithUploadParams.id, runContactOperationWithUploadParams.params, runContactOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runCustomOperationCallback(String string, String string2, HttpRequestData httpRequestData) {
        RunExternalRedirectCallbackParams runExternalRedirectCallbackParams = new RunExternalRedirectCallbackParams();
        runExternalRedirectCallbackParams.setId(this.apiHelper.fromId(string));
        runExternalRedirectCallbackParams.setToken(string2);
        runExternalRedirectCallbackParams.setRequest(this.apiHelper.toRequestInfo(httpRequestData));
        RunCustomOperationResult runCustomOperationResult = this.customOperationService.runExternalRedirectCallback(runExternalRedirectCallbackParams);
        return this.ok(this.operationsApiHelper.toRunOperationResult(runCustomOperationResult));
    }

    public ResponseEntity<RunOperationResult> runMenuOperation(String string, List<String> list, RunOperation runOperation) throws IOException {
        return this.doRun(OperationScopeEnum.MENU, null, string, runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runMenuOperationWithUpload(OperationsApi.RunMenuOperationWithUploadParams runMenuOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.MENU, null, runMenuOperationWithUploadParams.menu, runMenuOperationWithUploadParams.params, runMenuOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runOperation(String string, List<String> list, RunOperation runOperation) throws IOException {
        return this.doRun(OperationScopeEnum.INTERNAL, string, null, runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runOperationWithUpload(OperationsApi.RunOperationWithUploadParams runOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.INTERNAL, runOperationWithUploadParams.operation, null, runOperationWithUploadParams.params, runOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runOwnerOperation(OperationsApi.RunOwnerOperationParams runOwnerOperationParams) throws IOException {
        OperationScopeEnum operationScopeEnum = this.apiHelper.isSystem(runOwnerOperationParams.owner) ? OperationScopeEnum.SYSTEM : OperationScopeEnum.USER;
        return this.doRun(operationScopeEnum, runOwnerOperationParams.operation, runOwnerOperationParams.owner, runOwnerOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runOwnerOperationWithUpload(OperationsApi.RunOwnerOperationWithUploadParams runOwnerOperationWithUploadParams) throws IOException {
        OperationScopeEnum operationScopeEnum = this.apiHelper.isSystem(runOwnerOperationWithUploadParams.owner) ? OperationScopeEnum.SYSTEM : OperationScopeEnum.USER;
        return this.doRun(operationScopeEnum, runOwnerOperationWithUploadParams.operation, runOwnerOperationWithUploadParams.owner, runOwnerOperationWithUploadParams.params, runOwnerOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runRecordOperation(OperationsApi.RunRecordOperationParams runRecordOperationParams) throws IOException {
        return this.doRun(OperationScopeEnum.RECORD, runRecordOperationParams.operation, runRecordOperationParams.id, runRecordOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runRecordOperationWithUpload(OperationsApi.RunRecordOperationWithUploadParams runRecordOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.RECORD, runRecordOperationWithUploadParams.operation, runRecordOperationWithUploadParams.id, runRecordOperationWithUploadParams.params, runRecordOperationWithUploadParams.file);
    }

    public ResponseEntity<RunOperationResult> runTransferOperation(OperationsApi.RunTransferOperationParams runTransferOperationParams) throws IOException {
        return this.doRun(OperationScopeEnum.TRANSFER, runTransferOperationParams.operation, runTransferOperationParams.key, runTransferOperationParams.runOperation, null);
    }

    public ResponseEntity<RunOperationResult> runTransferOperationWithUpload(OperationsApi.RunTransferOperationWithUploadParams runTransferOperationWithUploadParams) throws IOException {
        return this.doRun(OperationScopeEnum.TRANSFER, runTransferOperationWithUploadParams.operation, runTransferOperationWithUploadParams.key, runTransferOperationWithUploadParams.params, runTransferOperationWithUploadParams.file);
    }

    private ResponseEntity<RunOperationResult> doRun(OperationScopeEnum operationScopeEnum, String string, String string2, RunOperation runOperation, MultipartFile multipartFile) throws IOException {
        RunCustomOperationDTO runCustomOperationDTO = this.operationsApiHelper.toRunCustomOperationDTO(operationScopeEnum, string, string2, runOperation, multipartFile);
        RunCustomOperationResult runCustomOperationResult = this.customOperationService.run(runCustomOperationDTO);
        FileInfo fileInfo = runCustomOperationResult.getFileDownload();
        if (fileInfo != null) {
            this.writeFile(fileInfo);
            return null;
        }
        RunOperationResult runOperationResult = this.operationsApiHelper.toRunOperationResult(runCustomOperationResult);
        this.fields().apply((Object)runOperationResult);
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        if (runOperationResult.getResultType() == OperationResultTypeEnum.RESULT_PAGE) {
            this.appendPageHeaders(bodyBuilder, runCustomOperationResult.getTotalCount(), runCustomOperationResult.getPageSize(), runCustomOperationResult.getCurrentPage(), runCustomOperationResult.getPageCount(), runCustomOperationResult.getHasNextPage(), false);
        }
        return bodyBuilder.body((Object)runOperationResult);
    }
}

