/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.OperationsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.HttpRequestData;
import org.cyclos.web.rest.model.Operation;
import org.cyclos.web.rest.model.OperationDataForRun;
import org.cyclos.web.rest.model.RunOperation;
import org.cyclos.web.rest.model.RunOperationResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(produces={"application/json"})
public class OperationsApi {
    @Autowired
    private OperationsApiImpl impl;
    public static final String GET_AD_OPERATION_DATA_FOR_RUN = "/marketplace/{ad}/operations/{operation}/data-for-run";
    public static final String GET_CONTACT_INFO_OPERATION_DATA_FOR_RUN = "/contact-infos/{id}/operations/{operation}/data-for-run";
    public static final String GET_CONTACT_OPERATION_DATA_FOR_RUN = "/contact-list/{id}/operations/{operation}/data-for-run";
    public static final String GET_MENU_OPERATION_DATA_FOR_RUN = "/menu/{menu}/operations/data-for-run";
    public static final String GET_OPERATION_DATA_FOR_RUN = "/operations/{operation}/data-for-run";
    public static final String GET_OWNER_OPERATION_DATA_FOR_RUN = "/{owner}/operations/{operation}/data-for-run";
    public static final String GET_RECORD_OPERATION_DATA_FOR_RUN = "/records/{id}/operations/{operation}/data-for-run";
    public static final String GET_TRANSFER_OPERATION_DATA_FOR_RUN = "/transfer/{key}/operations/{operation}/data-for-run";
    public static final String LIST_OPERATIONS_BY_AD = "/marketplace/{ad}/operations";
    public static final String LIST_OPERATIONS_BY_CONTACT = "/contact-list/{id}/operations";
    public static final String LIST_OPERATIONS_BY_CONTACT_INFO = "/contact-infos/{id}/operations";
    public static final String LIST_OPERATIONS_BY_OWNER = "/{owner}/operations";
    public static final String LIST_OPERATIONS_BY_RECORD = "/records/{id}/operations";
    public static final String LIST_OPERATIONS_BY_TRANSFER = "/transfers/{key}/operations";
    public static final String RUN_AD_OPERATION = "/marketplace/{ad}/operations/{operation}/run";
    public static final String RUN_AD_OPERATION_WITH_UPLOAD = "/marketplace/{ad}/operations/{operation}/run-upload";
    public static final String RUN_CONTACT_INFO_OPERATION = "/contact-infos/{id}/operations/{operation}/run";
    public static final String RUN_CONTACT_INFO_OPERATION_WITH_UPLOAD = "/contact-infos/{id}/operations/{operation}/run-upload";
    public static final String RUN_CONTACT_OPERATION = "/contact-list/{id}/operations/{operation}/run";
    public static final String RUN_CONTACT_OPERATION_WITH_UPLOAD = "/contact-list/{id}/operations/{operation}/run-upload";
    public static final String RUN_CUSTOM_OPERATION_CALLBACK = "/operations/callback/{id}";
    public static final String RUN_MENU_OPERATION = "/menu/{menu}/operations/run";
    public static final String RUN_MENU_OPERATION_WITH_UPLOAD = "/menu/{menu}/operations/run-upload";
    public static final String RUN_OPERATION = "/operations/{operation}/run";
    public static final String RUN_OPERATION_WITH_UPLOAD = "/operations/{operation}/run-upload";
    public static final String RUN_OWNER_OPERATION = "/{owner}/operations/{operation}/run";
    public static final String RUN_OWNER_OPERATION_WITH_UPLOAD = "/{owner}/operations/{operation}/run-upload";
    public static final String RUN_RECORD_OPERATION = "/records/{id}/operations/{operation}/run";
    public static final String RUN_RECORD_OPERATION_WITH_UPLOAD = "/records/{id}/operations/{operation}/run-upload";
    public static final String RUN_TRANSFER_OPERATION = "/transfers/{key}/operations/{operation}/run";
    public static final String RUN_TRANSFER_OPERATION_WITH_UPLOAD = "/transfers/{key}/operations/{operation}/run-upload";

    @RequestMapping(value={"/api/marketplace/{ad:.*}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getAdOperationDataForRun(@PathVariable(value="ad") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAdOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getContactInfoOperationDataForRun(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-infos/{id}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactInfoOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/contact-list/{id}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getContactOperationDataForRun(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-list/{id}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/menu/{menu}/operations/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getMenuOperationDataForRun(@PathVariable(value="menu") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /menu/{menu}/operations/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getMenuOperationDataForRun(string, list);
    }

    @RequestMapping(value={"/api/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getOperationDataForRun(@PathVariable(value="operation") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getOperationDataForRun(string, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getOwnerOperationDataForRun(@PathVariable(value="owner") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOwnerOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/records/{id}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getRecordOperationDataForRun(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /records/{id}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getRecordOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/transfer/{key}/operations/{operation}/data-for-run"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<OperationDataForRun> getTransferOperationDataForRun(@PathVariable(value="key") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfer/{key}/operations/{operation}/data-for-run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getTransferOperationDataForRun(string, string2, list);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByAd(@PathVariable(value="ad") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByAd(string, list);
    }

    @RequestMapping(value={"/api/contact-list/{id}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByContact(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-list/{id}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByContact(string, list);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByContactInfo(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-infos/{id}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByContactInfo(string, list);
    }

    @RequestMapping(value={"/api/{owner:.*}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByOwner(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByOwner(string, list);
    }

    @RequestMapping(value={"/api/records/{id}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByRecord(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /records/{id}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByRecord(string, list);
    }

    @RequestMapping(value={"/api/transfers/{key}/operations"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Operation>> listOperationsByTransfer(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /transfers/{key}/operations");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listOperationsByTransfer(string, list);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runAdOperation(@PathVariable(value="ad") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunAdOperationParams runAdOperationParams = new RunAdOperationParams();
        runAdOperationParams.ad = string;
        runAdOperationParams.operation = string2;
        runAdOperationParams.fields = list;
        runAdOperationParams.runOperation = runOperation;
        return this.impl.runAdOperation(runAdOperationParams);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runAdOperationWithUpload(@PathVariable(value="ad") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunAdOperationWithUploadParams runAdOperationWithUploadParams = new RunAdOperationWithUploadParams();
        runAdOperationWithUploadParams.ad = string;
        runAdOperationWithUploadParams.operation = string2;
        runAdOperationWithUploadParams.fields = list;
        runAdOperationWithUploadParams.params = runOperation;
        runAdOperationWithUploadParams.file = multipartFile;
        return this.impl.runAdOperationWithUpload(runAdOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runContactInfoOperation(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /contact-infos/{id}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunContactInfoOperationParams runContactInfoOperationParams = new RunContactInfoOperationParams();
        runContactInfoOperationParams.id = string;
        runContactInfoOperationParams.operation = string2;
        runContactInfoOperationParams.fields = list;
        runContactInfoOperationParams.runOperation = runOperation;
        return this.impl.runContactInfoOperation(runContactInfoOperationParams);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runContactInfoOperationWithUpload(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /contact-infos/{id}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunContactInfoOperationWithUploadParams runContactInfoOperationWithUploadParams = new RunContactInfoOperationWithUploadParams();
        runContactInfoOperationWithUploadParams.id = string;
        runContactInfoOperationWithUploadParams.operation = string2;
        runContactInfoOperationWithUploadParams.fields = list;
        runContactInfoOperationWithUploadParams.params = runOperation;
        runContactInfoOperationWithUploadParams.file = multipartFile;
        return this.impl.runContactInfoOperationWithUpload(runContactInfoOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/contact-list/{id}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runContactOperation(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /contact-list/{id}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunContactOperationParams runContactOperationParams = new RunContactOperationParams();
        runContactOperationParams.id = string;
        runContactOperationParams.operation = string2;
        runContactOperationParams.fields = list;
        runContactOperationParams.runOperation = runOperation;
        return this.impl.runContactOperation(runContactOperationParams);
    }

    @RequestMapping(value={"/api/contact-list/{id}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runContactOperationWithUpload(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /contact-list/{id}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunContactOperationWithUploadParams runContactOperationWithUploadParams = new RunContactOperationWithUploadParams();
        runContactOperationWithUploadParams.id = string;
        runContactOperationWithUploadParams.operation = string2;
        runContactOperationWithUploadParams.fields = list;
        runContactOperationWithUploadParams.params = runOperation;
        runContactOperationWithUploadParams.file = multipartFile;
        return this.impl.runContactOperationWithUpload(runContactOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/operations/callback/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runCustomOperationCallback(@PathVariable(value="id") String string, @RequestParam(value="token", required=false) String string2, @RequestBody(required=false) HttpRequestData httpRequestData, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /operations/callback/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.runCustomOperationCallback(string, string2, httpRequestData);
    }

    @RequestMapping(value={"/api/menu/{menu}/operations/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runMenuOperation(@PathVariable(value="menu") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /menu/{menu}/operations/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.runMenuOperation(string, list, runOperation);
    }

    @RequestMapping(value={"/api/menu/{menu}/operations/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runMenuOperationWithUpload(@PathVariable(value="menu") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /menu/{menu}/operations/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunMenuOperationWithUploadParams runMenuOperationWithUploadParams = new RunMenuOperationWithUploadParams();
        runMenuOperationWithUploadParams.menu = string;
        runMenuOperationWithUploadParams.fields = list;
        runMenuOperationWithUploadParams.params = runOperation;
        runMenuOperationWithUploadParams.file = multipartFile;
        return this.impl.runMenuOperationWithUpload(runMenuOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runOperation(@PathVariable(value="operation") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.runOperation(string, list, runOperation);
    }

    @RequestMapping(value={"/api/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runOperationWithUpload(@PathVariable(value="operation") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunOperationWithUploadParams runOperationWithUploadParams = new RunOperationWithUploadParams();
        runOperationWithUploadParams.operation = string;
        runOperationWithUploadParams.fields = list;
        runOperationWithUploadParams.params = runOperation;
        runOperationWithUploadParams.file = multipartFile;
        return this.impl.runOperationWithUpload(runOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runOwnerOperation(@PathVariable(value="owner") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        RunOwnerOperationParams runOwnerOperationParams = new RunOwnerOperationParams();
        runOwnerOperationParams.owner = string;
        runOwnerOperationParams.operation = string2;
        runOwnerOperationParams.fields = list;
        runOwnerOperationParams.runOperation = runOperation;
        return this.impl.runOwnerOperation(runOwnerOperationParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runOwnerOperationWithUpload(@PathVariable(value="owner") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunOwnerOperationWithUploadParams runOwnerOperationWithUploadParams = new RunOwnerOperationWithUploadParams();
        runOwnerOperationWithUploadParams.owner = string;
        runOwnerOperationWithUploadParams.operation = string2;
        runOwnerOperationWithUploadParams.fields = list;
        runOwnerOperationWithUploadParams.params = runOperation;
        runOwnerOperationWithUploadParams.file = multipartFile;
        return this.impl.runOwnerOperationWithUpload(runOwnerOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/records/{id}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runRecordOperation(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /records/{id}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunRecordOperationParams runRecordOperationParams = new RunRecordOperationParams();
        runRecordOperationParams.id = string;
        runRecordOperationParams.operation = string2;
        runRecordOperationParams.fields = list;
        runRecordOperationParams.runOperation = runOperation;
        return this.impl.runRecordOperation(runRecordOperationParams);
    }

    @RequestMapping(value={"/api/records/{id}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runRecordOperationWithUpload(@PathVariable(value="id") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /records/{id}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunRecordOperationWithUploadParams runRecordOperationWithUploadParams = new RunRecordOperationWithUploadParams();
        runRecordOperationWithUploadParams.id = string;
        runRecordOperationWithUploadParams.operation = string2;
        runRecordOperationWithUploadParams.fields = list;
        runRecordOperationWithUploadParams.params = runOperation;
        runRecordOperationWithUploadParams.file = multipartFile;
        return this.impl.runRecordOperationWithUpload(runRecordOperationWithUploadParams);
    }

    @RequestMapping(value={"/api/transfers/{key}/operations/{operation}/run"}, produces={"application/json", "*/*"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runTransferOperation(@PathVariable(value="key") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestBody(required=false) RunOperation runOperation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /transfers/{key}/operations/{operation}/run");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunTransferOperationParams runTransferOperationParams = new RunTransferOperationParams();
        runTransferOperationParams.key = string;
        runTransferOperationParams.operation = string2;
        runTransferOperationParams.fields = list;
        runTransferOperationParams.runOperation = runOperation;
        return this.impl.runTransferOperation(runTransferOperationParams);
    }

    @RequestMapping(value={"/api/transfers/{key}/operations/{operation}/run-upload"}, produces={"application/json", "*/*"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<RunOperationResult> runTransferOperationWithUpload(@PathVariable(value="key") String string, @PathVariable(value="operation") String string2, @RequestParam(value="fields", required=false) List<String> list, @RequestPart(value="params", required=false) RunOperation runOperation, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /transfers/{key}/operations/{operation}/run-upload");
        httpServletRequest.setAttribute("errorType", Error.class);
        RunTransferOperationWithUploadParams runTransferOperationWithUploadParams = new RunTransferOperationWithUploadParams();
        runTransferOperationWithUploadParams.key = string;
        runTransferOperationWithUploadParams.operation = string2;
        runTransferOperationWithUploadParams.fields = list;
        runTransferOperationWithUploadParams.params = runOperation;
        runTransferOperationWithUploadParams.file = multipartFile;
        return this.impl.runTransferOperationWithUpload(runTransferOperationWithUploadParams);
    }

    public static class RunAdOperationParams {
        public String ad;
        public static final String AD = "ad";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunAdOperationWithUploadParams {
        public String ad;
        public static final String AD = "ad";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunContactInfoOperationParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunContactInfoOperationWithUploadParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunContactOperationParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunContactOperationWithUploadParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunMenuOperationWithUploadParams {
        public String menu;
        public static final String MENU = "menu";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunOperationWithUploadParams {
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunOwnerOperationParams {
        public String owner;
        public static final String OWNER = "owner";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunOwnerOperationWithUploadParams {
        public String owner;
        public static final String OWNER = "owner";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunRecordOperationParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunRecordOperationWithUploadParams {
        public String id;
        public static final String ID = "id";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }

    public static class RunTransferOperationParams {
        public String key;
        public static final String KEY = "key";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation runOperation;
        public static final String RUN_OPERATION = "runOperation";
    }

    public static class RunTransferOperationWithUploadParams {
        public String key;
        public static final String KEY = "key";
        public String operation;
        public static final String OPERATION = "operation";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public RunOperation params;
        public static final String PARAMS = "params";
        public MultipartFile file;
        public static final String FILE = "file";
    }
}

