/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.OidcApiImpl;
import org.cyclos.web.rest.model.JWKSResponse;
import org.cyclos.web.rest.model.OidcError;
import org.cyclos.web.rest.model.OidcRegisterParams;
import org.cyclos.web.rest.model.OidcRegisterResult;
import org.cyclos.web.rest.model.OidcTokenResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class OidcApi {
    @Autowired
    private OidcApiImpl impl;
    public static final String OIDC_AUTHORIZE = "/oidc/authorize";
    public static final String OIDC_JWKS = "/oidc/jwks";
    public static final String OIDC_REGISTER = "/oidc/register";
    public static final String OIDC_REVOKE = "/oidc/revoke";
    public static final String OIDC_TOKEN = "/oidc/token";
    public static final String OIDC_USER_INFO_GET = "/oidc/userinfo";
    public static final String OIDC_USER_INFO_POST = "/oidc/userinfo";

    @RequestMapping(value={"/api/oidc/authorize"}, produces={"application/x-www-form-urlencoded"}, method={RequestMethod.GET})
    public ResponseEntity<Void> oidcAuthorize(@RequestParam(value="scope", required=true) String string, @RequestParam(value="response_type", required=true) String string2, @RequestParam(value="client_id", required=true) String string3, @RequestParam(value="redirect_uri", required=true) String string4, @RequestParam(value="state", required=false) String string5, @RequestParam(value="response_mode", required=false) String string6, @RequestParam(value="nonce", required=false) String string7, @RequestParam(value="display", required=false) String string8, @RequestParam(value="prompt", required=false) String string9, @RequestParam(value="login_hint", required=false) String string10, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /oidc/authorize");
        OidcAuthorizeParams oidcAuthorizeParams = new OidcAuthorizeParams();
        oidcAuthorizeParams.scope = string;
        oidcAuthorizeParams.responseType = string2;
        oidcAuthorizeParams.clientId = string3;
        oidcAuthorizeParams.redirectUri = string4;
        oidcAuthorizeParams.state = string5;
        oidcAuthorizeParams.responseMode = string6;
        oidcAuthorizeParams.nonce = string7;
        oidcAuthorizeParams.display = string8;
        oidcAuthorizeParams.prompt = string9;
        oidcAuthorizeParams.loginHint = string10;
        return this.impl.oidcAuthorize(oidcAuthorizeParams);
    }

    @RequestMapping(value={"/api/oidc/jwks"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<JWKSResponse> oidcJwks(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /oidc/jwks");
        return this.impl.oidcJwks();
    }

    @RequestMapping(value={"/api/oidc/register"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<OidcRegisterResult> oidcRegister(@RequestBody(required=true) OidcRegisterParams oidcRegisterParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /oidc/register");
        httpServletRequest.setAttribute("errorType", OidcError.class);
        return this.impl.oidcRegister(oidcRegisterParams);
    }

    @RequestMapping(value={"/api/oidc/revoke"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public ResponseEntity<Void> oidcRevoke(@RequestParam(value="token", required=true) String string, @RequestParam(value="client_id", required=false) String string2, @RequestParam(value="client_secret", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /oidc/revoke");
        return this.impl.oidcRevoke(string, string2, string3);
    }

    @RequestMapping(value={"/api/oidc/token"}, produces={"application/json"}, consumes={"application/x-www-form-urlencoded"}, method={RequestMethod.POST})
    public ResponseEntity<OidcTokenResult> oidcToken(@RequestParam(value="grant_type", required=true) String string, @RequestParam(value="client_id", required=false) String string2, @RequestParam(value="client_secret", required=false) String string3, @RequestParam(value="code", required=false) String string4, @RequestParam(value="redirect_uri", required=false) String string5, @RequestParam(value="refresh_token", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /oidc/token");
        httpServletRequest.setAttribute("errorType", OidcError.class);
        OidcTokenParams oidcTokenParams = new OidcTokenParams();
        oidcTokenParams.grantType = string;
        oidcTokenParams.clientId = string2;
        oidcTokenParams.clientSecret = string3;
        oidcTokenParams.code = string4;
        oidcTokenParams.redirectUri = string5;
        oidcTokenParams.refreshToken = string6;
        return this.impl.oidcToken(oidcTokenParams);
    }

    @RequestMapping(value={"/api/oidc/userinfo"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Object> oidcUserInfoGet(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /oidc/userinfo");
        httpServletRequest.setAttribute("errorType", OidcError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.oidcUserInfoGet();
    }

    @RequestMapping(value={"/api/oidc/userinfo"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Object> oidcUserInfoPost(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /oidc/userinfo");
        httpServletRequest.setAttribute("errorType", OidcError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.oidcUserInfoPost();
    }

    public static class OidcAuthorizeParams {
        public String scope;
        public static final String SCOPE = "scope";
        public String responseType;
        public static final String RESPONSE_TYPE = "responseType";
        public String clientId;
        public static final String CLIENT_ID = "clientId";
        public String redirectUri;
        public static final String REDIRECT_URI = "redirectUri";
        public String state;
        public static final String STATE = "state";
        public String responseMode;
        public static final String RESPONSE_MODE = "responseMode";
        public String nonce;
        public static final String NONCE = "nonce";
        public String display;
        public static final String DISPLAY = "display";
        public String prompt;
        public static final String PROMPT = "prompt";
        public String loginHint;
        public static final String LOGIN_HINT = "loginHint";
    }

    public static class OidcTokenParams {
        public String grantType;
        public static final String GRANT_TYPE = "grantType";
        public String clientId;
        public static final String CLIENT_ID = "clientId";
        public String clientSecret;
        public static final String CLIENT_SECRET = "clientSecret";
        public String code;
        public static final String CODE = "code";
        public String redirectUri;
        public static final String REDIRECT_URI = "redirectUri";
        public String refreshToken;
        public static final String REFRESH_TOKEN = "refreshToken";
    }
}

