/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.Optional;
import org.cyclos.model.messaging.notifications.NotificationQuery;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.NotificationsStatusVO;
import org.cyclos.model.users.users.UserActivityType;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.messaging.NotificationService;
import org.cyclos.services.users.BasicUserService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.NotificationsApi;
import org.cyclos.web.rest.helpers.NotificationsApiHelper;
import org.cyclos.web.rest.model.Notification;
import org.cyclos.web.rest.model.NotificationQueryFilters;
import org.cyclos.web.rest.model.NotificationsStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NotificationsApiImpl
extends BaseApiImpl {
    @Autowired
    private NotificationsApiHelper notificationsApiHelper;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private BasicUserService basicUserService;

    public ResponseEntity<Void> deleteNotification(String string) {
        this.notificationService.remove(this.apiHelper.fromId(string));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<Void> markNotificationsAsRead(List<String> list) {
        this.notificationService.markAsRead(this.apiHelper.fromIds(list));
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<NotificationsStatus> notificationsStatus() {
        NotificationsStatusVO notificationsStatusVO = this.notificationService.getNotificationsStatus();
        return this.ok(this.notificationsApiHelper.toNotificationsStatus(notificationsStatusVO));
    }

    public ResponseEntity<List<Notification>> searchNotifications(NotificationsApi.SearchNotificationsParams searchNotificationsParams) {
        NotificationQueryFilters notificationQueryFilters = (NotificationQueryFilters)ClassHelper.convert((Object)searchNotificationsParams, NotificationQueryFilters.class);
        NotificationQuery notificationQuery = this.notificationsApiHelper.toNotificationQuery(notificationQueryFilters);
        Page page = this.notificationService.search(notificationQuery);
        return this.pageResponse(page, notificationVO -> this.notificationsApiHelper.toNotification((NotificationVO)notificationVO, notificationVO.getType().getNotificationEntityType()));
    }

    public ResponseEntity<Void> updateLastViewDateForNotifications() {
        this.basicUserService.updateUserActivity(UserActivityType.NOTIFICATION);
        return this.okOrNoContent(Optional.empty());
    }

    public ResponseEntity<Notification> viewNotification(String string, List<String> list) {
        NotificationVO notificationVO = this.notificationService.load(this.apiHelper.fromId(string));
        return this.ok(this.notificationsApiHelper.toNotification(notificationVO, notificationVO.getType().getNotificationEntityType()));
    }
}

