/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.NotificationSettingsApiImpl;
import org.cyclos.web.rest.model.DataForEmailUnsubscribe;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.NotificationSettingsDataForEdit;
import org.cyclos.web.rest.model.NotificationSettingsEdit;
import org.cyclos.web.rest.model.NotificationSettingsView;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class NotificationSettingsApi {
    @Autowired
    private NotificationSettingsApiImpl impl;
    public static final String EMAIL_UNSUBSCRIBE = "/email-unsubscribe/{key}";
    public static final String GET_DATA_FOR_EMAIL_UNSUBSCRIBE = "/email-unsubscribe/{key}";
    public static final String GET_NOTIFICATION_SETTINGS_DATA_FOR_EDIT = "/{user}/notification-settings/data-for-edit";
    public static final String SAVE_NOTIFICATION_SETTINGS = "/{user}/notification-settings";
    public static final String VIEW_NOTIFICATION_SETTINGS = "/{user}/notification-settings";

    @RequestMapping(value={"/api/email-unsubscribe/{key}"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> emailUnsubscribe(@PathVariable(value="key") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /email-unsubscribe/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.emailUnsubscribe(string);
    }

    @RequestMapping(value={"/api/email-unsubscribe/{key}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForEmailUnsubscribe> getDataForEmailUnsubscribe(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /email-unsubscribe/{key}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getDataForEmailUnsubscribe(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/notification-settings/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<NotificationSettingsDataForEdit> getNotificationSettingsDataForEdit(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/notification-settings/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getNotificationSettingsDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/notification-settings"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> saveNotificationSettings(@PathVariable(value="user") String string, @RequestBody(required=true) NotificationSettingsEdit notificationSettingsEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/notification-settings");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.saveNotificationSettings(string, notificationSettingsEdit);
    }

    @RequestMapping(value={"/api/{user:.*}/notification-settings"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<NotificationSettingsView> viewNotificationSettings(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/notification-settings");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewNotificationSettings(string, list);
    }
}

