/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.NfcApiImpl;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.InitializeNfcError;
import org.cyclos.web.rest.model.NfcAuthError;
import org.cyclos.web.rest.model.NfcDataForInitialize;
import org.cyclos.web.rest.model.NfcDataForPersonalize;
import org.cyclos.web.rest.model.NfcExternalAuthenticateParameter;
import org.cyclos.web.rest.model.NfcExternalAuthenticateResult;
import org.cyclos.web.rest.model.NfcInitializeParameter;
import org.cyclos.web.rest.model.NfcInitializeResult;
import org.cyclos.web.rest.model.NfcPersonalizeDataParameter;
import org.cyclos.web.rest.model.NfcPersonalizeParameter;
import org.cyclos.web.rest.model.NfcTokenParameter;
import org.cyclos.web.rest.model.PersonalizeNfcError;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.TokenDetailed;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class NfcApi {
    @Autowired
    private NfcApiImpl impl;
    public static final String CANCEL_NFC = "/nfc/cancel";
    public static final String CREATE_DEVICE_CONFIRMATION_FOR_PERSONALIZE_NFC = "/nfc/personalize/device-confirmations";
    public static final String DELETE_DEVICE_CONFIRMATION_FOR_PERSONALIZE_NFC = "/nfc/personalize/device-confirmations/{id}";
    public static final String GET_DEVICE_CONFIRMATION_QR_CODE_FOR_PERSONALIZE_NFC = "/nfc/personalize/device-confirmations/{id}/qr-code";
    public static final String GET_NFC_DATA_FOR_INITIALIZE = "/nfc/data-for-initialize";
    public static final String GET_NFC_DATA_FOR_PERSONALIZE = "/nfc/data-for-personalize";
    public static final String GET_NFC_TOKEN = "/nfc/{tokenType}/{value}";
    public static final String GET_OTP_FOR_PERSONALIZE_NFC = "/nfc/personalize/otp";
    public static final String INITIALIZE_NFC = "/nfc/initialize";
    public static final String NFC_EXTERNAL_AUTH = "/nfc/external-auth";
    public static final String PERSONALIZE_NFC = "/nfc/personalize";
    public static final String VIEW_DEVICE_CONFIRMATION_FOR_PERSONALIZE_NFC = "/nfc/personalize/device-confirmations/{id}";

    @RequestMapping(value={"/api/nfc/cancel"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelNfc(@RequestBody(required=true) NfcTokenParameter nfcTokenParameter, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelNfc(nfcTokenParameter);
    }

    @RequestMapping(value={"/api/nfc/personalize/device-confirmations"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createDeviceConfirmationForPersonalizeNfc(@RequestBody(required=true) NfcPersonalizeDataParameter nfcPersonalizeDataParameter, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/personalize/device-confirmations");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createDeviceConfirmationForPersonalizeNfc(nfcPersonalizeDataParameter);
    }

    @RequestMapping(value={"/api/nfc/personalize/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDeviceConfirmationForPersonalizeNfc(@PathVariable(value="id") String string, @RequestParam(value="user", required=true) String string2, @RequestParam(value="type", required=true) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /nfc/personalize/device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDeviceConfirmationForPersonalizeNfc(string, string2, string3);
    }

    @RequestMapping(value={"/api/nfc/personalize/device-confirmations/{id}/qr-code"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getDeviceConfirmationQrCodeForPersonalizeNfc(@PathVariable(value="id") String string, @RequestParam(value="user", required=true) String string2, @RequestParam(value="type", required=true) String string3, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /nfc/personalize/device-confirmations/{id}/qr-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetDeviceConfirmationQrCodeForPersonalizeNfcParams getDeviceConfirmationQrCodeForPersonalizeNfcParams = new GetDeviceConfirmationQrCodeForPersonalizeNfcParams();
        getDeviceConfirmationQrCodeForPersonalizeNfcParams.id = string;
        getDeviceConfirmationQrCodeForPersonalizeNfcParams.user = string2;
        getDeviceConfirmationQrCodeForPersonalizeNfcParams.type = string3;
        getDeviceConfirmationQrCodeForPersonalizeNfcParams.size = imageSizeEnum;
        return this.impl.getDeviceConfirmationQrCodeForPersonalizeNfc(getDeviceConfirmationQrCodeForPersonalizeNfcParams);
    }

    @RequestMapping(value={"/api/nfc/data-for-initialize"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<NfcDataForInitialize> getNfcDataForInitialize(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /nfc/data-for-initialize");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getNfcDataForInitialize(list);
    }

    @RequestMapping(value={"/api/nfc/data-for-personalize"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<NfcDataForPersonalize> getNfcDataForPersonalize(@RequestParam(value="tokenType", required=true) String string, @RequestParam(value="user", required=true) String string2, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /nfc/data-for-personalize");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getNfcDataForPersonalize(string, string2, list);
    }

    @RequestMapping(value={"/api/nfc/{tokenType}/{value}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<TokenDetailed> getNfcToken(@PathVariable(value="tokenType") String string, @PathVariable(value="value") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /nfc/{tokenType}/{value}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getNfcToken(string, string2);
    }

    @RequestMapping(value={"/api/nfc/personalize/otp"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> getOtpForPersonalizeNfc(@RequestParam(value="medium", required=true) SendMediumEnum sendMediumEnum, @RequestBody(required=true) NfcPersonalizeDataParameter nfcPersonalizeDataParameter, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/personalize/otp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getOtpForPersonalizeNfc(sendMediumEnum, nfcPersonalizeDataParameter);
    }

    @RequestMapping(value={"/api/nfc/initialize"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<NfcInitializeResult> initializeNfc(@RequestBody(required=true) NfcInitializeParameter nfcInitializeParameter, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/initialize");
        httpServletRequest.setAttribute("errorType", InitializeNfcError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.initializeNfc(nfcInitializeParameter);
    }

    @RequestMapping(value={"/api/nfc/external-auth"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<NfcExternalAuthenticateResult> nfcExternalAuth(@RequestBody(required=true) NfcExternalAuthenticateParameter nfcExternalAuthenticateParameter, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/external-auth");
        httpServletRequest.setAttribute("errorType", NfcAuthError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.nfcExternalAuth(nfcExternalAuthenticateParameter);
    }

    @RequestMapping(value={"/api/nfc/personalize"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> personalizeNfc(@RequestBody(required=true) NfcPersonalizeParameter nfcPersonalizeParameter, @RequestHeader(value="confirmationPassword", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /nfc/personalize");
        httpServletRequest.setAttribute("errorType", PersonalizeNfcError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.personalizeNfc(nfcPersonalizeParameter, string);
    }

    @RequestMapping(value={"/api/nfc/personalize/device-confirmations/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeviceConfirmationView> viewDeviceConfirmationForPersonalizeNfc(@PathVariable(value="id") String string, @RequestParam(value="user", required=true) String string2, @RequestParam(value="type", required=true) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /nfc/personalize/device-confirmations/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewDeviceConfirmationForPersonalizeNfc(string, string2, string3);
    }

    public static class GetDeviceConfirmationQrCodeForPersonalizeNfcParams {
        public String id;
        public static final String ID = "id";
        public String user;
        public static final String USER = "user";
        public String type;
        public static final String TYPE = "type";
        public ImageSizeEnum size;
        public static final String SIZE = "size";
    }
}

