/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.users.users.RegionalSettingsDTO;
import org.cyclos.model.utils.LocalesData;
import org.cyclos.services.users.UserRegionalSettingsService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.LocalizationApiHelper;
import org.cyclos.web.rest.model.LocalizationSettings;
import org.cyclos.web.rest.model.UserLocale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class LocalizationApiImpl
extends BaseApiImpl {
    @Autowired
    private LocalizationApiHelper localizationApiHelper;
    @Autowired
    private UserRegionalSettingsService userRegionalSettingsService;

    public ResponseEntity<List<UserLocale>> getLocales() {
        LocalesData localesData = this.userRegionalSettingsService.getLocalesData();
        List list = localesData.getAllowedLocales().stream().map(this.localizationApiHelper::toUserLocale).collect(Collectors.toList());
        return this.ok(list);
    }

    public ResponseEntity<Void> saveLocalizationSettings(LocalizationSettings localizationSettings) {
        RegionalSettingsDTO regionalSettingsDTO = this.localizationApiHelper.toRegionalSettings(localizationSettings);
        this.userRegionalSettingsService.save(regionalSettingsDTO);
        return this.ok();
    }
}

