/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.LocalizationApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.LocalizationSettings;
import org.cyclos.web.rest.model.UserLocale;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(produces={"application/json"})
public class LocalizationApi {
    @Autowired
    private LocalizationApiImpl impl;
    public static final String GET_LOCALES = "/localization/locales";
    public static final String SAVE_LOCALIZATION_SETTINGS = "/localization/settings";

    @RequestMapping(value={"/api/localization/locales"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<UserLocale>> getLocales(HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /localization/locales");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getLocales();
    }

    @RequestMapping(value={"/api/localization/settings"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> saveLocalizationSettings(@RequestBody(required=true) LocalizationSettings localizationSettings, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /localization/settings");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.saveLocalizationSettings(localizationSettings);
    }
}

