/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.InstallmentsApiImpl;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.InstallmentDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewDataForSearch;
import org.cyclos.web.rest.model.InstallmentOverviewResult;
import org.cyclos.web.rest.model.InstallmentResult;
import org.cyclos.web.rest.model.InstallmentStatusEnum;
import org.cyclos.web.rest.model.PaymentCreationTypeEnum;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.TransOrderByEnum;
import org.cyclos.web.rest.model.TransactionAuthorizationStatusEnum;
import org.cyclos.web.rest.model.TransactionKind;
import org.cyclos.web.rest.model.Transfer;
import org.cyclos.web.rest.model.TransferDirectionEnum;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class InstallmentsApi {
    @Autowired
    private InstallmentsApiImpl impl;
    public static final String EXPORT_INSTALLMENTS = "/{owner}/installments/export/{format}";
    public static final String EXPORT_INSTALLMENTS_OVERVIEW = "/installments/export/{format}";
    public static final String GET_INSTALLMENTS_DATA_FOR_SEARCH = "/{owner}/installments/data-for-search";
    public static final String GET_INSTALLMENTS_OVERVIEW_DATA_FOR_SEARCH = "/installments/data-for-search";
    public static final String PROCESS_INSTALLMENT = "/installments/{key}/process";
    public static final String SEARCH_INSTALLMENTS = "/{owner}/installments";
    public static final String SEARCH_INSTALLMENTS_OVERVIEW = "/installments";
    public static final String SETTLE_INSTALLMENT = "/installments/{key}/settle";

    @RequestMapping(value={"/api/{owner:.*}/installments/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportInstallments(@PathVariable(value="owner") String string, @PathVariable(value="format") String string2, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="accountTypes", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="authorizationPerformedBy", required=false) String string3, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list4, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list5, @RequestParam(value="by", required=false) String string4, @RequestParam(value="channels", required=false) List<String> list6, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list7, @RequestParam(value="customFields", required=false) List<String> list8, @RequestParam(value="datePeriod", required=false) List<DateTime> list9, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list10, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list11, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list12, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<InstallmentStatusEnum> list13, @RequestParam(value="transactionNumber", required=false) String string5, @RequestParam(value="transferFilters", required=false) List<String> list14, @RequestParam(value="transferTypes", required=false) List<String> list15, @RequestParam(value="user", required=false) String string6, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/installments/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportInstallmentsParams exportInstallmentsParams = new ExportInstallmentsParams();
        exportInstallmentsParams.owner = string;
        exportInstallmentsParams.format = string2;
        exportInstallmentsParams.accessClients = list;
        exportInstallmentsParams.accountTypes = list2;
        exportInstallmentsParams.amountRange = list3;
        exportInstallmentsParams.authorizationPerformedBy = string3;
        exportInstallmentsParams.authorizationStatuses = list4;
        exportInstallmentsParams.authorized = bl;
        exportInstallmentsParams.brokers = list5;
        exportInstallmentsParams.by = string4;
        exportInstallmentsParams.channels = list6;
        exportInstallmentsParams.creationTypes = list7;
        exportInstallmentsParams.customFields = list8;
        exportInstallmentsParams.datePeriod = list9;
        exportInstallmentsParams.direction = transferDirectionEnum;
        exportInstallmentsParams.excludedIds = list10;
        exportInstallmentsParams.fromCurrentAccessClient = bl2;
        exportInstallmentsParams.groups = list11;
        exportInstallmentsParams.includeGeneratedByAccessClient = bl3;
        exportInstallmentsParams.kinds = list12;
        exportInstallmentsParams.orderBy = transOrderByEnum;
        exportInstallmentsParams.page = n;
        exportInstallmentsParams.pageSize = n2;
        exportInstallmentsParams.skipTotalCount = bl4;
        exportInstallmentsParams.statuses = list13;
        exportInstallmentsParams.transactionNumber = string5;
        exportInstallmentsParams.transferFilters = list14;
        exportInstallmentsParams.transferTypes = list15;
        exportInstallmentsParams.user = string6;
        return this.impl.exportInstallments(exportInstallmentsParams);
    }

    @RequestMapping(value={"/api/installments/export/{format}"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> exportInstallmentsOverview(@PathVariable(value="format") String string, @RequestParam(value="accessClients", required=false) List<String> list, @RequestParam(value="amountRange", required=false) List<BigDecimal> list2, @RequestParam(value="authorizationPerformedBy", required=false) String string2, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list3, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list4, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list5, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list6, @RequestParam(value="currencies", required=false) List<String> list7, @RequestParam(value="customFields", required=false) List<String> list8, @RequestParam(value="datePeriod", required=false) List<DateTime> list9, @RequestParam(value="excludedIds", required=false) List<String> list10, @RequestParam(value="fromAccountTypes", required=false) List<String> list11, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list12, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list13, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<InstallmentStatusEnum> list14, @RequestParam(value="toAccountTypes", required=false) List<String> list15, @RequestParam(value="transactionNumber", required=false) String string4, @RequestParam(value="transferFilters", required=false) List<String> list16, @RequestParam(value="transferTypes", required=false) List<String> list17, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /installments/export/{format}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        ExportInstallmentsOverviewParams exportInstallmentsOverviewParams = new ExportInstallmentsOverviewParams();
        exportInstallmentsOverviewParams.format = string;
        exportInstallmentsOverviewParams.accessClients = list;
        exportInstallmentsOverviewParams.amountRange = list2;
        exportInstallmentsOverviewParams.authorizationPerformedBy = string2;
        exportInstallmentsOverviewParams.authorizationStatuses = list3;
        exportInstallmentsOverviewParams.authorized = bl;
        exportInstallmentsOverviewParams.brokers = list4;
        exportInstallmentsOverviewParams.by = string3;
        exportInstallmentsOverviewParams.channels = list5;
        exportInstallmentsOverviewParams.creationTypes = list6;
        exportInstallmentsOverviewParams.currencies = list7;
        exportInstallmentsOverviewParams.customFields = list8;
        exportInstallmentsOverviewParams.datePeriod = list9;
        exportInstallmentsOverviewParams.excludedIds = list10;
        exportInstallmentsOverviewParams.fromAccountTypes = list11;
        exportInstallmentsOverviewParams.fromCurrentAccessClient = bl2;
        exportInstallmentsOverviewParams.groups = list12;
        exportInstallmentsOverviewParams.includeGeneratedByAccessClient = bl3;
        exportInstallmentsOverviewParams.kinds = list13;
        exportInstallmentsOverviewParams.orderBy = transOrderByEnum;
        exportInstallmentsOverviewParams.page = n;
        exportInstallmentsOverviewParams.pageSize = n2;
        exportInstallmentsOverviewParams.skipTotalCount = bl4;
        exportInstallmentsOverviewParams.statuses = list14;
        exportInstallmentsOverviewParams.toAccountTypes = list15;
        exportInstallmentsOverviewParams.transactionNumber = string4;
        exportInstallmentsOverviewParams.transferFilters = list16;
        exportInstallmentsOverviewParams.transferTypes = list17;
        exportInstallmentsOverviewParams.user = string5;
        return this.impl.exportInstallmentsOverview(exportInstallmentsOverviewParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/installments/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InstallmentDataForSearch> getInstallmentsDataForSearch(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/installments/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getInstallmentsDataForSearch(string, list);
    }

    @RequestMapping(value={"/api/installments/data-for-search"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InstallmentOverviewDataForSearch> getInstallmentsOverviewDataForSearch(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /installments/data-for-search");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getInstallmentsOverviewDataForSearch(list);
    }

    @RequestMapping(value={"/api/installments/{key}/process"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transfer> processInstallment(@PathVariable(value="key") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /installments/{key}/process");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.processInstallment(string, list, string2);
    }

    @RequestMapping(value={"/api/{owner:.*}/installments"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<InstallmentResult>> searchInstallments(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="accountTypes", required=false) List<String> list3, @RequestParam(value="amountRange", required=false) List<BigDecimal> list4, @RequestParam(value="authorizationPerformedBy", required=false) String string2, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list5, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list6, @RequestParam(value="by", required=false) String string3, @RequestParam(value="channels", required=false) List<String> list7, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list8, @RequestParam(value="customFields", required=false) List<String> list9, @RequestParam(value="datePeriod", required=false) List<DateTime> list10, @RequestParam(value="direction", required=false) TransferDirectionEnum transferDirectionEnum, @RequestParam(value="excludedIds", required=false) List<String> list11, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list12, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list13, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<InstallmentStatusEnum> list14, @RequestParam(value="transactionNumber", required=false) String string4, @RequestParam(value="transferFilters", required=false) List<String> list15, @RequestParam(value="transferTypes", required=false) List<String> list16, @RequestParam(value="user", required=false) String string5, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/installments");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchInstallmentsParams searchInstallmentsParams = new SearchInstallmentsParams();
        searchInstallmentsParams.owner = string;
        searchInstallmentsParams.fields = list;
        searchInstallmentsParams.accessClients = list2;
        searchInstallmentsParams.accountTypes = list3;
        searchInstallmentsParams.amountRange = list4;
        searchInstallmentsParams.authorizationPerformedBy = string2;
        searchInstallmentsParams.authorizationStatuses = list5;
        searchInstallmentsParams.authorized = bl;
        searchInstallmentsParams.brokers = list6;
        searchInstallmentsParams.by = string3;
        searchInstallmentsParams.channels = list7;
        searchInstallmentsParams.creationTypes = list8;
        searchInstallmentsParams.customFields = list9;
        searchInstallmentsParams.datePeriod = list10;
        searchInstallmentsParams.direction = transferDirectionEnum;
        searchInstallmentsParams.excludedIds = list11;
        searchInstallmentsParams.fromCurrentAccessClient = bl2;
        searchInstallmentsParams.groups = list12;
        searchInstallmentsParams.includeGeneratedByAccessClient = bl3;
        searchInstallmentsParams.kinds = list13;
        searchInstallmentsParams.orderBy = transOrderByEnum;
        searchInstallmentsParams.page = n;
        searchInstallmentsParams.pageSize = n2;
        searchInstallmentsParams.skipTotalCount = bl4;
        searchInstallmentsParams.statuses = list14;
        searchInstallmentsParams.transactionNumber = string4;
        searchInstallmentsParams.transferFilters = list15;
        searchInstallmentsParams.transferTypes = list16;
        searchInstallmentsParams.user = string5;
        return this.impl.searchInstallments(searchInstallmentsParams);
    }

    @RequestMapping(value={"/api/installments"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<InstallmentOverviewResult>> searchInstallmentsOverview(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="accessClients", required=false) List<String> list2, @RequestParam(value="amountRange", required=false) List<BigDecimal> list3, @RequestParam(value="authorizationPerformedBy", required=false) String string, @RequestParam(value="authorizationStatuses", required=false) List<TransactionAuthorizationStatusEnum> list4, @RequestParam(value="authorized", required=false) Boolean bl, @RequestParam(value="brokers", required=false) List<String> list5, @RequestParam(value="by", required=false) String string2, @RequestParam(value="channels", required=false) List<String> list6, @RequestParam(value="creationTypes", required=false) List<PaymentCreationTypeEnum> list7, @RequestParam(value="currencies", required=false) List<String> list8, @RequestParam(value="customFields", required=false) List<String> list9, @RequestParam(value="datePeriod", required=false) List<DateTime> list10, @RequestParam(value="excludedIds", required=false) List<String> list11, @RequestParam(value="fromAccountTypes", required=false) List<String> list12, @RequestParam(value="fromCurrentAccessClient", required=false) Boolean bl2, @RequestParam(value="groups", required=false) List<String> list13, @RequestParam(value="includeGeneratedByAccessClient", required=false) Boolean bl3, @RequestParam(value="kinds", required=false) List<TransactionKind> list14, @RequestParam(value="orderBy", required=false) TransOrderByEnum transOrderByEnum, @RequestParam(value="page", required=false) Integer n, @RequestParam(value="pageSize", required=false) Integer n2, @RequestParam(value="skipTotalCount", required=false) Boolean bl4, @RequestParam(value="statuses", required=false) List<InstallmentStatusEnum> list15, @RequestParam(value="toAccountTypes", required=false) List<String> list16, @RequestParam(value="transactionNumber", required=false) String string3, @RequestParam(value="transferFilters", required=false) List<String> list17, @RequestParam(value="transferTypes", required=false) List<String> list18, @RequestParam(value="user", required=false) String string4, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /installments");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        SearchInstallmentsOverviewParams searchInstallmentsOverviewParams = new SearchInstallmentsOverviewParams();
        searchInstallmentsOverviewParams.fields = list;
        searchInstallmentsOverviewParams.accessClients = list2;
        searchInstallmentsOverviewParams.amountRange = list3;
        searchInstallmentsOverviewParams.authorizationPerformedBy = string;
        searchInstallmentsOverviewParams.authorizationStatuses = list4;
        searchInstallmentsOverviewParams.authorized = bl;
        searchInstallmentsOverviewParams.brokers = list5;
        searchInstallmentsOverviewParams.by = string2;
        searchInstallmentsOverviewParams.channels = list6;
        searchInstallmentsOverviewParams.creationTypes = list7;
        searchInstallmentsOverviewParams.currencies = list8;
        searchInstallmentsOverviewParams.customFields = list9;
        searchInstallmentsOverviewParams.datePeriod = list10;
        searchInstallmentsOverviewParams.excludedIds = list11;
        searchInstallmentsOverviewParams.fromAccountTypes = list12;
        searchInstallmentsOverviewParams.fromCurrentAccessClient = bl2;
        searchInstallmentsOverviewParams.groups = list13;
        searchInstallmentsOverviewParams.includeGeneratedByAccessClient = bl3;
        searchInstallmentsOverviewParams.kinds = list14;
        searchInstallmentsOverviewParams.orderBy = transOrderByEnum;
        searchInstallmentsOverviewParams.page = n;
        searchInstallmentsOverviewParams.pageSize = n2;
        searchInstallmentsOverviewParams.skipTotalCount = bl4;
        searchInstallmentsOverviewParams.statuses = list15;
        searchInstallmentsOverviewParams.toAccountTypes = list16;
        searchInstallmentsOverviewParams.transactionNumber = string3;
        searchInstallmentsOverviewParams.transferFilters = list17;
        searchInstallmentsOverviewParams.transferTypes = list18;
        searchInstallmentsOverviewParams.user = string4;
        return this.impl.searchInstallmentsOverview(searchInstallmentsOverviewParams);
    }

    @RequestMapping(value={"/api/installments/{key}/settle"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> settleInstallment(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /installments/{key}/settle");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.settleInstallment(string, string2);
    }

    public static class ExportInstallmentsParams {
        public String owner;
        public static final String OWNER = "owner";
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<String> accountTypes;
        public static final String ACCOUNT_TYPES = "accountTypes";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<InstallmentStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class ExportInstallmentsOverviewParams {
        public String format;
        public static final String FORMAT = "format";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<InstallmentStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchInstallmentsParams {
        public String owner;
        public static final String OWNER = "owner";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<String> accountTypes;
        public static final String ACCOUNT_TYPES = "accountTypes";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public TransferDirectionEnum direction;
        public static final String DIRECTION = "direction";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<InstallmentStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }

    public static class SearchInstallmentsOverviewParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public List<String> accessClients;
        public static final String ACCESS_CLIENTS = "accessClients";
        public List<BigDecimal> amountRange;
        public static final String AMOUNT_RANGE = "amountRange";
        public String authorizationPerformedBy;
        public static final String AUTHORIZATION_PERFORMED_BY = "authorizationPerformedBy";
        public List<TransactionAuthorizationStatusEnum> authorizationStatuses;
        public static final String AUTHORIZATION_STATUSES = "authorizationStatuses";
        public Boolean authorized;
        public static final String AUTHORIZED = "authorized";
        public List<String> brokers;
        public static final String BROKERS = "brokers";
        public String by;
        public static final String BY = "by";
        public List<String> channels;
        public static final String CHANNELS = "channels";
        public List<PaymentCreationTypeEnum> creationTypes;
        public static final String CREATION_TYPES = "creationTypes";
        public List<String> currencies;
        public static final String CURRENCIES = "currencies";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public List<DateTime> datePeriod;
        public static final String DATE_PERIOD = "datePeriod";
        public List<String> excludedIds;
        public static final String EXCLUDED_IDS = "excludedIds";
        public List<String> fromAccountTypes;
        public static final String FROM_ACCOUNT_TYPES = "fromAccountTypes";
        public Boolean fromCurrentAccessClient;
        public static final String FROM_CURRENT_ACCESS_CLIENT = "fromCurrentAccessClient";
        public List<String> groups;
        public static final String GROUPS = "groups";
        public Boolean includeGeneratedByAccessClient;
        public static final String INCLUDE_GENERATED_BY_ACCESS_CLIENT = "includeGeneratedByAccessClient";
        public List<TransactionKind> kinds;
        public static final String KINDS = "kinds";
        public TransOrderByEnum orderBy;
        public static final String ORDER_BY = "orderBy";
        public Integer page;
        public static final String PAGE = "page";
        public Integer pageSize;
        public static final String PAGE_SIZE = "pageSize";
        public Boolean skipTotalCount;
        public static final String SKIP_TOTAL_COUNT = "skipTotalCount";
        public List<InstallmentStatusEnum> statuses;
        public static final String STATUSES = "statuses";
        public List<String> toAccountTypes;
        public static final String TO_ACCOUNT_TYPES = "toAccountTypes";
        public String transactionNumber;
        public static final String TRANSACTION_NUMBER = "transactionNumber";
        public List<String> transferFilters;
        public static final String TRANSFER_FILTERS = "transferFilters";
        public List<String> transferTypes;
        public static final String TRANSFER_TYPES = "transferTypes";
        public String user;
        public static final String USER = "user";
    }
}

