/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ImagesApiImpl;
import org.cyclos.web.rest.model.CustomFieldKind;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.Image;
import org.cyclos.web.rest.model.ImageView;
import org.cyclos.web.rest.model.ImagesListData;
import org.cyclos.web.rest.model.LogoKind;
import org.cyclos.web.rest.model.SystemImagesListData;
import org.cyclos.web.rest.model.TempImageTargetEnum;
import org.cyclos.web.rest.model.ThemeImageKind;
import org.cyclos.web.rest.model.UserImageKind;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(produces={"application/json"})
public class ImagesApi {
    @Autowired
    private ImagesApiImpl impl;
    public static final String DELETE_IMAGE = "/images/{id}";
    public static final String GET_AD_IMAGES_LIST_DATA = "/marketplace/{ad}/images/list-data";
    public static final String GET_CONFIGURATION_LOGO_CONTENT = "/logos/{configuration}/{kind}";
    public static final String GET_CURRENT_LOGO_CONTENT = "/logos/{kind}";
    public static final String GET_CURRENT_THEME_IMAGE_CONTENT = "/themes/images/{kind}/{name}";
    public static final String GET_IMAGE_CONTENT = "/images/content/{id}";
    public static final String GET_SVG_ICONS = "/svg-icons";
    public static final String GET_SYSTEM_CUSTOM_IMAGES_LIST_DATA = "/system-images/list-data";
    public static final String GET_THEME_IMAGE_CONTENT = "/themes/{theme}/images/{kind}/{name}";
    public static final String GET_USER_IMAGES_LIST_DATA = "/{user}/images/list-data";
    public static final String LIST_AD_IMAGES = "/marketplace/{ad}/images";
    public static final String LIST_TEMP_IMAGES = "/images/temp";
    public static final String LIST_USER_IMAGES = "/{user}/images";
    public static final String REORDER_AD_IMAGES = "/marketplace/{ad}/images/order";
    public static final String REORDER_PROFILE_IMAGES = "/{user}/images/order";
    public static final String UPLOAD_AD_IMAGE = "/marketplace/{ad}/images";
    public static final String UPLOAD_CONTACT_INFO_IMAGE = "/contact-infos/{id}/image";
    public static final String UPLOAD_SYSTEM_CUSTOM_IMAGE = "/system-images/{category}";
    public static final String UPLOAD_TEMP_IMAGE = "/images/temp";
    public static final String UPLOAD_USER_IMAGE = "/{user}/images";
    public static final String VIEW_IMAGE = "/images/{id}";
    public static final String VIEW_SVG_ICON = "/svg-icons/{name}.svg";

    @RequestMapping(value={"/api/images/{id:.*}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteImage(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /images/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.deleteImage(string);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/images/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImagesListData> getAdImagesListData(@PathVariable(value="ad") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/images/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAdImagesListData(string, list);
    }

    @RequestMapping(value={"/api/logos/{configuration}/{kind}"}, produces={"image/_*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getConfigurationLogoContent(@PathVariable(value="configuration") String string, @PathVariable(value="kind") LogoKind logoKind, @RequestParam(value="width", required=false) Integer n, @RequestParam(value="height", required=false) Integer n2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /logos/{configuration}/{kind}");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetConfigurationLogoContentParams getConfigurationLogoContentParams = new GetConfigurationLogoContentParams();
        getConfigurationLogoContentParams._configuration = string;
        getConfigurationLogoContentParams.kind = logoKind;
        getConfigurationLogoContentParams.width = n;
        getConfigurationLogoContentParams.height = n2;
        return this.impl.getConfigurationLogoContent(getConfigurationLogoContentParams);
    }

    @RequestMapping(value={"/api/logos/{kind}"}, produces={"image/_*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getCurrentLogoContent(@PathVariable(value="kind") LogoKind logoKind, @RequestParam(value="width", required=false) Integer n, @RequestParam(value="height", required=false) Integer n2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /logos/{kind}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getCurrentLogoContent(logoKind, n, n2);
    }

    @RequestMapping(value={"/api/themes/images/{kind}/{name:.*}"}, produces={"image/_*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getCurrentThemeImageContent(@PathVariable(value="kind") ThemeImageKind themeImageKind, @PathVariable(value="name") String string, @RequestParam(value="width", required=false) Integer n, @RequestParam(value="height", required=false) Integer n2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /themes/images/{kind}/{name}");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetCurrentThemeImageContentParams getCurrentThemeImageContentParams = new GetCurrentThemeImageContentParams();
        getCurrentThemeImageContentParams.kind = themeImageKind;
        getCurrentThemeImageContentParams.name = string;
        getCurrentThemeImageContentParams.width = n;
        getCurrentThemeImageContentParams.height = n2;
        return this.impl.getCurrentThemeImageContent(getCurrentThemeImageContentParams);
    }

    @RequestMapping(value={"/api/images/content/{id:.*}"}, produces={"image/_*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getImageContent(@PathVariable(value="id") String string, @RequestParam(value="width", required=false) Integer n, @RequestParam(value="height", required=false) Integer n2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /images/content/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getImageContent(string, n, n2);
    }

    @RequestMapping(value={"/api/svg-icons"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Map<String, String>> getSvgIcons(@RequestParam(value="names", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /svg-icons");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getSvgIcons(list);
    }

    @RequestMapping(value={"/api/system-images/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<SystemImagesListData> getSystemCustomImagesListData(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /system-images/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getSystemCustomImagesListData(list);
    }

    @RequestMapping(value={"/api/themes/{theme}/images/{kind}/{name:.*}"}, produces={"image/_*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getThemeImageContent(@PathVariable(value="theme") String string, @PathVariable(value="kind") ThemeImageKind themeImageKind, @PathVariable(value="name") String string2, @RequestParam(value="width", required=false) Integer n, @RequestParam(value="height", required=false) Integer n2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /themes/{theme}/images/{kind}/{name}");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetThemeImageContentParams getThemeImageContentParams = new GetThemeImageContentParams();
        getThemeImageContentParams.theme = string;
        getThemeImageContentParams.kind = themeImageKind;
        getThemeImageContentParams.name = string2;
        getThemeImageContentParams.width = n;
        getThemeImageContentParams.height = n2;
        return this.impl.getThemeImageContent(getThemeImageContentParams);
    }

    @RequestMapping(value={"/api/{user:.*}/images/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImagesListData> getUserImagesListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="kind", required=false) UserImageKind userImageKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/images/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserImagesListData(string, list, userImageKind);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/images"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Image>> listAdImages(@PathVariable(value="ad") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace/{ad}/images");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listAdImages(string, list);
    }

    @RequestMapping(value={"/api/images/temp"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Image>> listTempImages(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="target", required=false) TempImageTargetEnum tempImageTargetEnum, @RequestParam(value="guestKey", required=false) String string, @RequestParam(value="user", required=false) String string2, @RequestParam(value="customField", required=false) String string3, @RequestParam(value="customFieldKind", required=false) CustomFieldKind customFieldKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /images/temp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ListTempImagesParams listTempImagesParams = new ListTempImagesParams();
        listTempImagesParams.fields = list;
        listTempImagesParams.target = tempImageTargetEnum;
        listTempImagesParams.guestKey = string;
        listTempImagesParams.user = string2;
        listTempImagesParams.customField = string3;
        listTempImagesParams.customFieldKind = customFieldKind;
        return this.impl.listTempImages(listTempImagesParams);
    }

    @RequestMapping(value={"/api/{user:.*}/images"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Image>> listUserImages(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="kind", required=false) UserImageKind userImageKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/images");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listUserImages(string, list, userImageKind);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/images/order"}, produces={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> reorderAdImages(@PathVariable(value="ad") String string, @RequestParam(value="ids", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /marketplace/{ad}/images/order");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.reorderAdImages(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/images/order"}, produces={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> reorderProfileImages(@PathVariable(value="user") String string, @RequestParam(value="ids", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /{user}/images/order");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.reorderProfileImages(string, list);
    }

    @RequestMapping(value={"/api/marketplace/{ad:.*}/images"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadAdImage(@PathVariable(value="ad") String string, @RequestParam(value="name", required=false) String string2, @RequestPart(value="image", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /marketplace/{ad}/images");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.uploadAdImage(string, string2, multipartFile);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/image"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadContactInfoImage(@PathVariable(value="id") String string, @RequestParam(value="name", required=false) String string2, @RequestPart(value="image", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /contact-infos/{id}/image");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.uploadContactInfoImage(string, string2, multipartFile);
    }

    @RequestMapping(value={"/api/system-images/{category}"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadSystemCustomImage(@PathVariable(value="category") String string, @RequestParam(value="name", required=false) String string2, @RequestPart(value="image", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /system-images/{category}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.uploadSystemCustomImage(string, string2, multipartFile);
    }

    @RequestMapping(value={"/api/images/temp"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadTempImage(@RequestParam(value="name", required=false) String string, @RequestParam(value="target", required=false) TempImageTargetEnum tempImageTargetEnum, @RequestParam(value="guestKey", required=false) String string2, @RequestParam(value="user", required=false) String string3, @RequestParam(value="customField", required=false) String string4, @RequestParam(value="customFieldKind", required=false) CustomFieldKind customFieldKind, @RequestPart(value="image", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /images/temp");
        httpServletRequest.setAttribute("errorType", Error.class);
        UploadTempImageParams uploadTempImageParams = new UploadTempImageParams();
        uploadTempImageParams.name = string;
        uploadTempImageParams.target = tempImageTargetEnum;
        uploadTempImageParams.guestKey = string2;
        uploadTempImageParams.user = string3;
        uploadTempImageParams.customField = string4;
        uploadTempImageParams.customFieldKind = customFieldKind;
        uploadTempImageParams.image = multipartFile;
        return this.impl.uploadTempImage(uploadTempImageParams);
    }

    @RequestMapping(value={"/api/{user:.*}/images"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadUserImage(@PathVariable(value="user") String string, @RequestParam(value="kind", required=false) UserImageKind userImageKind, @RequestParam(value="name", required=false) String string2, @RequestPart(value="image", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/images");
        httpServletRequest.setAttribute("errorType", Error.class);
        UploadUserImageParams uploadUserImageParams = new UploadUserImageParams();
        uploadUserImageParams.user = string;
        uploadUserImageParams.kind = userImageKind;
        uploadUserImageParams.name = string2;
        uploadUserImageParams.image = multipartFile;
        return this.impl.uploadUserImage(uploadUserImageParams);
    }

    @RequestMapping(value={"/api/images/{id:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ImageView> viewImage(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /images/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewImage(string, list);
    }

    @RequestMapping(value={"/api/svg-icons/{name:.*}.svg"}, produces={"text/plain", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<String> viewSvgIcon(@PathVariable(value="name") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /svg-icons/{name}.svg");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewSvgIcon(string, list);
    }

    public static class GetConfigurationLogoContentParams {
        public String _configuration;
        public static final String _CONFIGURATION = "_configuration";
        public LogoKind kind;
        public static final String KIND = "kind";
        public Integer width;
        public static final String WIDTH = "width";
        public Integer height;
        public static final String HEIGHT = "height";
    }

    public static class GetCurrentThemeImageContentParams {
        public ThemeImageKind kind;
        public static final String KIND = "kind";
        public String name;
        public static final String NAME = "name";
        public Integer width;
        public static final String WIDTH = "width";
        public Integer height;
        public static final String HEIGHT = "height";
    }

    public static class GetThemeImageContentParams {
        public String theme;
        public static final String THEME = "theme";
        public ThemeImageKind kind;
        public static final String KIND = "kind";
        public String name;
        public static final String NAME = "name";
        public Integer width;
        public static final String WIDTH = "width";
        public Integer height;
        public static final String HEIGHT = "height";
    }

    public static class ListTempImagesParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public TempImageTargetEnum target;
        public static final String TARGET = "target";
        public String guestKey;
        public static final String GUEST_KEY = "guestKey";
        public String user;
        public static final String USER = "user";
        public String customField;
        public static final String CUSTOM_FIELD = "customField";
        public CustomFieldKind customFieldKind;
        public static final String CUSTOM_FIELD_KIND = "customFieldKind";
    }

    public static class UploadTempImageParams {
        public String name;
        public static final String NAME = "name";
        public TempImageTargetEnum target;
        public static final String TARGET = "target";
        public String guestKey;
        public static final String GUEST_KEY = "guestKey";
        public String user;
        public static final String USER = "user";
        public String customField;
        public static final String CUSTOM_FIELD = "customField";
        public CustomFieldKind customFieldKind;
        public static final String CUSTOM_FIELD_KIND = "customFieldKind";
        public MultipartFile image;
        public static final String IMAGE = "image";
    }

    public static class UploadUserImageParams {
        public String user;
        public static final String USER = "user";
        public UserImageKind kind;
        public static final String KIND = "kind";
        public String name;
        public static final String NAME = "name";
        public MultipartFile image;
        public static final String IMAGE = "image";
    }
}

