/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.FilesApiImpl;
import org.cyclos.web.rest.model.CustomFieldKind;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.StoredFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(produces={"application/json"})
public class FilesApi {
    @Autowired
    private FilesApiImpl impl;
    public static final String DELETE_RAW_FILE = "/files/{id}";
    public static final String GET_RAW_FILE_CONTENT = "/files/{id}/content";
    public static final String LIST_TEMP_FILES = "/files/temp";
    public static final String UPLOAD_TEMP_FILE = "/files/temp";
    public static final String VIEW_RAW_FILE = "/files/{id}";

    @RequestMapping(value={"/api/files/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteRawFile(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /files/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.deleteRawFile(string);
    }

    @RequestMapping(value={"/api/files/{id}/content"}, produces={"*/*", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getRawFileContent(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /files/{id}/content");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.getRawFileContent(string);
    }

    @RequestMapping(value={"/api/files/temp"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<StoredFile>> listTempFiles(@RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="guestKey", required=false) String string, @RequestParam(value="customField", required=false) String string2, @RequestParam(value="customFieldKind", required=false) CustomFieldKind customFieldKind, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /files/temp");
        httpServletRequest.setAttribute("errorType", Error.class);
        ListTempFilesParams listTempFilesParams = new ListTempFilesParams();
        listTempFilesParams.fields = list;
        listTempFilesParams.guestKey = string;
        listTempFilesParams.customField = string2;
        listTempFilesParams.customFieldKind = customFieldKind;
        return this.impl.listTempFiles(listTempFilesParams);
    }

    @RequestMapping(value={"/api/files/temp"}, produces={"text/plain", "application/json"}, consumes={"multipart/form-data"}, method={RequestMethod.POST})
    public ResponseEntity<String> uploadTempFile(@RequestParam(value="name", required=false) String string, @RequestParam(value="guestKey", required=false) String string2, @RequestParam(value="customField", required=false) String string3, @RequestParam(value="customFieldKind", required=false) CustomFieldKind customFieldKind, @RequestPart(value="file", required=false) MultipartFile multipartFile, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /files/temp");
        httpServletRequest.setAttribute("errorType", Error.class);
        UploadTempFileParams uploadTempFileParams = new UploadTempFileParams();
        uploadTempFileParams.name = string;
        uploadTempFileParams.guestKey = string2;
        uploadTempFileParams.customField = string3;
        uploadTempFileParams.customFieldKind = customFieldKind;
        uploadTempFileParams.file = multipartFile;
        return this.impl.uploadTempFile(uploadTempFileParams);
    }

    @RequestMapping(value={"/api/files/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<StoredFile> viewRawFile(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /files/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.viewRawFile(string, list);
    }

    public static class ListTempFilesParams {
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String guestKey;
        public static final String GUEST_KEY = "guestKey";
        public String customField;
        public static final String CUSTOM_FIELD = "customField";
        public CustomFieldKind customFieldKind;
        public static final String CUSTOM_FIELD_KIND = "customFieldKind";
    }

    public static class UploadTempFileParams {
        public String name;
        public static final String NAME = "name";
        public String guestKey;
        public static final String GUEST_KEY = "guestKey";
        public String customField;
        public static final String CUSTOM_FIELD = "customField";
        public CustomFieldKind customFieldKind;
        public static final String CUSTOM_FIELD_KIND = "customFieldKind";
        public MultipartFile file;
        public static final String FILE = "file";
    }
}

