/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.EasyInvoicesApiImpl;
import org.cyclos.web.rest.model.DataForEasyInvoice;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class EasyInvoicesApi {
    @Autowired
    private EasyInvoicesApiImpl impl;
    public static final String DATA_FOR_PERFORM_EASY_INVOICE = "/easy-invoices/data-for-perform/{to}";
    public static final String GET_EASY_INVOICE_QR_CODE = "/easy-invoices/qr-code/{to}";
    public static final String PERFORM_EASY_INVOICE = "/easy-invoices";
    public static final String PREVIEW_EASY_INVOICE = "/easy-invoices/preview";

    @RequestMapping(value={"/api/easy-invoices/data-for-perform/{to:.*}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForEasyInvoice> dataForPerformEasyInvoice(@PathVariable(value="to") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="amount", required=false) BigDecimal bigDecimal, @RequestParam(value="type", required=false) String string2, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="customFields", required=false) List<String> list2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /easy-invoices/data-for-perform/{to}");
        httpServletRequest.setAttribute("errorType", Error.class);
        DataForPerformEasyInvoiceParams dataForPerformEasyInvoiceParams = new DataForPerformEasyInvoiceParams();
        dataForPerformEasyInvoiceParams.to = string;
        dataForPerformEasyInvoiceParams.fields = list;
        dataForPerformEasyInvoiceParams.amount = bigDecimal;
        dataForPerformEasyInvoiceParams.type = string2;
        dataForPerformEasyInvoiceParams.currency = string3;
        dataForPerformEasyInvoiceParams.customFields = list2;
        return this.impl.dataForPerformEasyInvoice(dataForPerformEasyInvoiceParams);
    }

    @RequestMapping(value={"/api/easy-invoices/qr-code/{to:.*}"}, produces={"image/png", "application/json"}, method={RequestMethod.GET})
    public ResponseEntity<InputStream> getEasyInvoiceQrCode(@PathVariable(value="to") String string, @RequestParam(value="amount", required=false) BigDecimal bigDecimal, @RequestParam(value="currency", required=false) String string2, @RequestParam(value="description", required=false) String string3, @RequestParam(value="type", required=false) String string4, @RequestParam(value="customFields", required=false) List<String> list, @RequestParam(value="size", required=false) ImageSizeEnum imageSizeEnum, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /easy-invoices/qr-code/{to}");
        httpServletRequest.setAttribute("errorType", Error.class);
        GetEasyInvoiceQrCodeParams getEasyInvoiceQrCodeParams = new GetEasyInvoiceQrCodeParams();
        getEasyInvoiceQrCodeParams.to = string;
        getEasyInvoiceQrCodeParams.amount = bigDecimal;
        getEasyInvoiceQrCodeParams.currency = string2;
        getEasyInvoiceQrCodeParams.description = string3;
        getEasyInvoiceQrCodeParams.type = string4;
        getEasyInvoiceQrCodeParams.customFields = list;
        getEasyInvoiceQrCodeParams.size = imageSizeEnum;
        return this.impl.getEasyInvoiceQrCode(getEasyInvoiceQrCodeParams);
    }

    @RequestMapping(value={"/api/easy-invoices"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> performEasyInvoice(@RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /easy-invoices");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.performEasyInvoice(performPayment, list, string);
    }

    @RequestMapping(value={"/api/easy-invoices/preview"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<PaymentPreview> previewEasyInvoice(@RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /easy-invoices/preview");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewEasyInvoice(performPayment, list);
    }

    public static class DataForPerformEasyInvoiceParams {
        public String to;
        public static final String TO = "to";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public BigDecimal amount;
        public static final String AMOUNT = "amount";
        public String type;
        public static final String TYPE = "type";
        public String currency;
        public static final String CURRENCY = "currency";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
    }

    public static class GetEasyInvoiceQrCodeParams {
        public String to;
        public static final String TO = "to";
        public BigDecimal amount;
        public static final String AMOUNT = "amount";
        public String currency;
        public static final String CURRENCY = "currency";
        public String description;
        public static final String DESCRIPTION = "description";
        public String type;
        public static final String TYPE = "type";
        public List<String> customFields;
        public static final String CUSTOM_FIELDS = "customFields";
        public ImageSizeEnum size;
        public static final String SIZE = "size";
    }
}

