/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.contentmanagement.documents.DocumentDTO;
import org.cyclos.model.contentmanagement.documents.DocumentData;
import org.cyclos.model.contentmanagement.documents.DocumentDataParams;
import org.cyclos.model.contentmanagement.documents.DocumentNature;
import org.cyclos.model.contentmanagement.documents.DocumentQuery;
import org.cyclos.model.contentmanagement.documents.DocumentSearchData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.contentmanagement.documents.DynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.StaticDocumentDTO;
import org.cyclos.model.contentmanagement.documents.UserDocumentDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.contentmanagement.DocumentService;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.DocumentsApi;
import org.cyclos.web.rest.helpers.DocumentsApiHelper;
import org.cyclos.web.rest.model.DataForDynamicDocument;
import org.cyclos.web.rest.model.Document;
import org.cyclos.web.rest.model.DocumentDataForEdit;
import org.cyclos.web.rest.model.DocumentDataForNew;
import org.cyclos.web.rest.model.DocumentDataForSearch;
import org.cyclos.web.rest.model.DocumentEdit;
import org.cyclos.web.rest.model.DocumentManage;
import org.cyclos.web.rest.model.DocumentNew;
import org.cyclos.web.rest.model.DocumentQueryFilters;
import org.cyclos.web.rest.model.DocumentResult;
import org.cyclos.web.rest.model.DocumentView;
import org.cyclos.web.rest.model.ProcessDynamicDocument;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DocumentsApiImpl
extends BaseApiImpl {
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentsApiHelper documentsApiHelper;
    @Autowired
    private JsonConverter jsonConverter;

    public ResponseEntity<String> createSharedDocument(DocumentNew documentNew) {
        StaticDocumentDTO staticDocumentDTO = this.documentsApiHelper.toDocumentDTO(StaticDocumentDTO.class, documentNew);
        return this.doCreate((DocumentDTO)staticDocumentDTO);
    }

    public ResponseEntity<String> createSharedDocumentWithUpload(MultipartFile multipartFile, DocumentNew documentNew, String string) throws Exception {
        documentNew = this.resolveDocument(DocumentNew.class, documentNew);
        string = this.resolveFileName(string);
        StaticDocumentDTO staticDocumentDTO = this.documentsApiHelper.toDocumentDTO(StaticDocumentDTO.class, documentNew);
        Long l = this.saveWithFile((DocumentDTO)staticDocumentDTO, multipartFile, string);
        return this.created(this.apiHelper.uriFromApi("documents", l), l);
    }

    public ResponseEntity<String> createUserDocument(String string, DocumentNew documentNew) {
        UserDocumentDTO userDocumentDTO = this.documentsApiHelper.toDocumentDTO(UserDocumentDTO.class, documentNew);
        userDocumentDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        return this.doCreate((DocumentDTO)userDocumentDTO);
    }

    public ResponseEntity<String> createUserDocumentWithUpload(DocumentsApi.CreateUserDocumentWithUploadParams createUserDocumentWithUploadParams) throws Exception {
        createUserDocumentWithUploadParams.document = this.resolveDocument(DocumentNew.class, createUserDocumentWithUploadParams.document);
        createUserDocumentWithUploadParams.fileName = this.resolveFileName(createUserDocumentWithUploadParams.fileName);
        UserDocumentDTO userDocumentDTO = this.documentsApiHelper.toDocumentDTO(UserDocumentDTO.class, createUserDocumentWithUploadParams.document);
        userDocumentDTO.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)createUserDocumentWithUploadParams.user));
        Long l = this.saveWithFile((DocumentDTO)userDocumentDTO, createUserDocumentWithUploadParams.file, createUserDocumentWithUploadParams.fileName);
        return this.created(this.apiHelper.uriFromApi("documents", l), l);
    }

    public ResponseEntity<Void> deleteDocument(String string) {
        this.documentService.remove(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputStream> downloadDocumentFile(String string) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        DocumentVO documentVO = (DocumentVO)ModelHelper.voFromString(DocumentVO.class, (String)string);
        RawFileVO rawFileVO = this.documentService.getDocumentFile(documentVO);
        SerializableInputStream serializableInputStream = this.documentService.readContent(documentVO);
        ServletHelper.setFileName(httpServletResponse, rawFileVO.getName(), false);
        httpServletResponse.setContentType(rawFileVO.getContentType());
        httpServletResponse.setContentLength(rawFileVO.getLength());
        IOHelper.copyAndClose((InputStream)serializableInputStream, (OutputStream)httpServletResponse.getOutputStream());
        return null;
    }

    public ResponseEntity<DataForDynamicDocument> getDataForDynamicDocument(String string, String string2, List<String> list) {
        DocumentVO documentVO = new DocumentVO(this.apiHelper.fromId(string));
        UserLocatorVO userLocatorVO = (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2);
        ProcessDynamicDocumentData processDynamicDocumentData = this.documentService.getProcessDynamicDocumentData(documentVO, userLocatorVO);
        DataForDynamicDocument dataForDynamicDocument = this.documentsApiHelper.toDataForDynamicDocument(processDynamicDocumentData);
        return this.ok(dataForDynamicDocument);
    }

    public ResponseEntity<DocumentDataForEdit> getDocumentDataForEdit(String string, List<String> list) {
        Long l = this.apiHelper.fromId(string);
        DocumentData documentData = (DocumentData)this.documentService.getData(l);
        if (documentData instanceof DynamicDocumentData) {
            throw new EntityNotFoundException(Document.class, l);
        }
        DocumentDataForEdit documentDataForEdit = this.documentsApiHelper.toDocumentDataForEdit(string, documentData);
        return this.ok(documentDataForEdit);
    }

    public ResponseEntity<DocumentDataForSearch> getDocumentsDataForSearch(List<String> list, String string) {
        DocumentSearchData documentSearchData = this.documentService.getDocumentSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        DocumentDataForSearch documentDataForSearch = this.documentsApiHelper.toDocumentDataForSearch(documentSearchData);
        return this.ok(documentDataForSearch);
    }

    public ResponseEntity<DocumentDataForNew> getSharedDocumentDataForNew(List<String> list) {
        DocumentDataParams documentDataParams = new DocumentDataParams();
        documentDataParams.setNature(DocumentNature.STATIC);
        return this.doGetDataForNew(documentDataParams, list);
    }

    public ResponseEntity<DocumentDataForNew> getUserDocumentDataForNew(String string, List<String> list) {
        DocumentDataParams documentDataParams = new DocumentDataParams();
        documentDataParams.setNature(DocumentNature.USER);
        documentDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        return this.doGetDataForNew(documentDataParams, list);
    }

    public ResponseEntity<List<Document>> listUserDocuments(String string, List<String> list) {
        List list2 = this.documentService.listUserDocuments((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list3 = list2.stream().map(this.documentsApiHelper::toDocument).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<String> processDynamicDocument(String string, String string2, ProcessDynamicDocument processDynamicDocument) {
        ProcessDynamicDocumentDTO processDynamicDocumentDTO = this.documentsApiHelper.toProcessDynamicDocumentDTO(string, string2, processDynamicDocument);
        String string3 = this.documentService.processDynamicDocument(processDynamicDocumentDTO);
        return this.html(string3);
    }

    public ResponseEntity<List<DocumentResult>> searchDocuments(DocumentsApi.SearchDocumentsParams searchDocumentsParams) {
        DocumentQueryFilters documentQueryFilters = (DocumentQueryFilters)ClassHelper.convert((Object)searchDocumentsParams, DocumentQueryFilters.class);
        DocumentQuery documentQuery = this.documentsApiHelper.toDocumentQuery(documentQueryFilters);
        Page page = this.documentService.search(documentQuery);
        return this.pageResponse(page, this.documentsApiHelper::toDocumentResult);
    }

    public ResponseEntity<Void> updateDocument(String string, DocumentEdit documentEdit) {
        Long l = this.apiHelper.fromId(string);
        DocumentVO documentVO = this.documentService.getDocument(new DocumentVO(l));
        if (documentVO.getNature() == DocumentNature.DYNAMIC) {
            throw new EntityNotFoundException(Document.class, l);
        }
        Class clazz = documentVO.getNature() == DocumentNature.STATIC ? StaticDocumentDTO.class : UserDocumentDTO.class;
        StaticDocumentDTO staticDocumentDTO = this.documentsApiHelper.toDocumentDTO(clazz, documentEdit);
        staticDocumentDTO.setId(l);
        this.documentService.save((EntityDTO)staticDocumentDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> updateDocumentWithUpload(DocumentsApi.UpdateDocumentWithUploadParams updateDocumentWithUploadParams) throws Exception {
        updateDocumentWithUploadParams.document = this.resolveDocument(DocumentEdit.class, updateDocumentWithUploadParams.document);
        updateDocumentWithUploadParams.fileName = this.resolveFileName(updateDocumentWithUploadParams.fileName);
        Long l = this.apiHelper.fromId(updateDocumentWithUploadParams.id);
        DocumentVO documentVO = this.documentService.getDocument(new DocumentVO(l));
        if (documentVO.getNature() == DocumentNature.DYNAMIC) {
            throw new EntityNotFoundException(Document.class, l);
        }
        Class clazz = documentVO.getNature() == DocumentNature.STATIC ? StaticDocumentDTO.class : UserDocumentDTO.class;
        StaticDocumentDTO staticDocumentDTO = this.documentsApiHelper.toDocumentDTO(clazz, updateDocumentWithUploadParams.document);
        staticDocumentDTO.setId(l);
        this.saveWithFile((DocumentDTO)staticDocumentDTO, updateDocumentWithUploadParams.file, updateDocumentWithUploadParams.fileName);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> uploadDocumentFile(String string, MultipartFile multipartFile, String string2) throws IOException {
        DocumentVO documentVO = new DocumentVO(this.apiHelper.fromId(string));
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            String string3 = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string2), (Object)multipartFile.getOriginalFilename());
            this.documentService.saveFile(documentVO, multipartFile.getContentType(), string3, serializableInputStream);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).location(this.apiHelper.uriFromApi("documents", string, "file"))).build();
    }

    public ResponseEntity<DocumentView> viewDocument(String string, List<String> list) {
        DocumentData documentData = (DocumentData)this.documentService.getData(this.apiHelper.fromId(string));
        DocumentView documentView = this.documentsApiHelper.toDocumentView(documentData);
        return this.ok(documentView);
    }

    private ResponseEntity<String> doCreate(DocumentDTO documentDTO) {
        Long l = this.documentService.save((EntityDTO)documentDTO);
        return this.created(this.apiHelper.uriFromApi("documents", l), l);
    }

    private ResponseEntity<DocumentDataForNew> doGetDataForNew(DocumentDataParams documentDataParams, List<String> list) {
        DocumentData documentData = (DocumentData)this.documentService.getDataForNew((Object)documentDataParams);
        DocumentDataForNew documentDataForNew = this.documentsApiHelper.toDocumentDataForNew(documentData);
        return this.ok(documentDataForNew);
    }

    private <T extends DocumentManage> T resolveDocument(Class<T> clazz, T t) throws Exception {
        if (t == null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)ServletHelper.getRequest().getAttribute("request");
            return (T)((DocumentManage)this.jsonConverter.readValue(StringHelper.trimToNull((Object)httpServletRequest.getParameter("document")), clazz));
        }
        return t;
    }

    private String resolveFileName(String string) {
        if (string == null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)ServletHelper.getRequest().getAttribute("request");
            return StringHelper.trimToNull((Object)httpServletRequest.getParameter("fileName"));
        }
        return string;
    }

    private Long saveWithFile(DocumentDTO documentDTO, MultipartFile multipartFile, String string) throws IOException {
        try (SerializableInputStream serializableInputStream = new SerializableInputStream(multipartFile.getInputStream());){
            string = (String)ObjectHelper.defaultValue((Object)StringHelper.trimToNull((Object)string), (Object)multipartFile.getOriginalFilename());
            Long l = this.documentService.saveWithFile(documentDTO, multipartFile.getContentType(), string, serializableInputStream);
            return l;
        }
    }
}

