/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.DevicesApiImpl;
import org.cyclos.web.rest.model.ActivationRequest;
import org.cyclos.web.rest.model.DataForSendingOtp;
import org.cyclos.web.rest.model.Device;
import org.cyclos.web.rest.model.DeviceActivation;
import org.cyclos.web.rest.model.DeviceActivationInfo;
import org.cyclos.web.rest.model.DeviceActivationResult;
import org.cyclos.web.rest.model.DeviceDataForEdit;
import org.cyclos.web.rest.model.DeviceEdit;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.SendActivationCodeRequest;
import org.cyclos.web.rest.model.SendActivationCodeResult;
import org.cyclos.web.rest.model.SendOtpWithId;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class DevicesApi {
    @Autowired
    private DevicesApiImpl impl;
    public static final String DELETE_DEVICE = "/devices/{id}";
    public static final String DEVICE_ACTIVATION = "/devices/activate";
    public static final String DEVICE_ACTIVATION_IF_POSSIBLE = "/devices/activate-if-possible";
    public static final String GET_DEVICE_DATA_FOR_EDIT = "/devices/{id}/data-for-edit";
    public static final String GET_DEVICE_DATA_FOR_SEND = "/devices/data-for-send";
    public static final String GET_PASSWORD_INPUT_FOR_REMOVE_DEVICE = "/devices/{id}/password-for-remove";
    public static final String LIST_DEVICES = "/{user}/devices";
    public static final String RESEND_DEVICE_ACTIVATION_CODE = "/devices/{id}/resend-activation-code";
    public static final String SEND_DEVICE_ACTIVATION_CODE = "/devices/send-activation-code";
    public static final String UPDATE_DEVICE = "/devices/{id}";

    @RequestMapping(value={"/api/devices/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteDevice(@PathVariable(value="id") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /devices/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteDevice(string, string2);
    }

    @RequestMapping(value={"/api/devices/activate"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<DeviceActivationResult> deviceActivation(@RequestBody(required=true) DeviceActivation deviceActivation, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /devices/activate");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deviceActivation(deviceActivation);
    }

    @RequestMapping(value={"/api/devices/activate-if-possible"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<DeviceActivationInfo> deviceActivationIfPossible(@RequestBody(required=true) ActivationRequest activationRequest, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /devices/activate-if-possible");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deviceActivationIfPossible(activationRequest, list);
    }

    @RequestMapping(value={"/api/devices/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DeviceDataForEdit> getDeviceDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /devices/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDeviceDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/devices/data-for-send"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForSendingOtp> getDeviceDataForSend(@RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /devices/data-for-send");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getDeviceDataForSend(list);
    }

    @RequestMapping(value={"/api/devices/{id}/password-for-remove"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForRemoveDevice(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /devices/{id}/password-for-remove");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForRemoveDevice(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/devices"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<Device>> listDevices(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/devices");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listDevices(string, list);
    }

    @RequestMapping(value={"/api/devices/{id}/resend-activation-code"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<SendActivationCodeResult> resendDeviceActivationCode(@PathVariable(value="id") String string, @RequestBody(required=true) SendOtpWithId sendOtpWithId, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /devices/{id}/resend-activation-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.resendDeviceActivationCode(string, sendOtpWithId);
    }

    @RequestMapping(value={"/api/devices/send-activation-code"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<SendActivationCodeResult> sendDeviceActivationCode(@RequestBody(required=true) SendActivationCodeRequest sendActivationCodeRequest, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /devices/send-activation-code");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.sendDeviceActivationCode(sendActivationCodeRequest);
    }

    @RequestMapping(value={"/api/devices/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateDevice(@PathVariable(value="id") String string, @RequestBody(required=true) DeviceEdit deviceEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /devices/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateDevice(string, deviceEdit);
    }
}

