/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.pins.CreatePinDTO;
import org.cyclos.model.access.pins.PinDTO;
import org.cyclos.model.access.pins.PinData;
import org.cyclos.model.access.pins.PinDetailedVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.access.pins.SetPinParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.PinService;
import org.cyclos.utils.ValidationResult;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.exceptions.ExceptionHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DevicePinsApiHelper;
import org.cyclos.web.rest.model.CreateDevicePin;
import org.cyclos.web.rest.model.CreateDevicePinResult;
import org.cyclos.web.rest.model.DevicePin;
import org.cyclos.web.rest.model.DevicePinDataForEdit;
import org.cyclos.web.rest.model.DevicePinEdit;
import org.cyclos.web.rest.model.DevicePinRemoveParams;
import org.cyclos.web.rest.model.DevicePinView;
import org.cyclos.web.rest.model.InputError;
import org.cyclos.web.rest.model.PasswordInput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class DevicePinsApiImpl
extends BaseApiImpl {
    @Autowired
    private PinService pinService;
    @Autowired
    private DevicePinsApiHelper devicePinsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private ExceptionHelper exceptionHelper;

    public ResponseEntity<Void> deleteDevicePin(String string, DevicePinRemoveParams devicePinRemoveParams) {
        this.ensureDevicePinKey(string);
        PinLocatorVO pinLocatorVO = (PinLocatorVO)ModelHelper.voFromString(PinLocatorVO.class, (String)string);
        this.pinService.remove(pinLocatorVO, this.devicePinsApiHelper.toCurrentPinAndPassword(devicePinRemoveParams));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DevicePinDataForEdit> getDevicePinDataForEdit(String string, List<String> list) {
        this.ensureDevicePinKey(string);
        PinData pinData = this.pinService.getEditData((PinLocatorVO)ModelHelper.voFromString(PinLocatorVO.class, (String)string));
        return this.ok(this.devicePinsApiHelper.toDevicePinDataForEdit(pinData));
    }

    public ResponseEntity<PasswordInput> getPasswordInputForCreatePin(List<String> list) {
        CredentialInputDTO credentialInputDTO = this.pinService.getPasswordInputForCreate();
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<List<DevicePin>> listDevicePins(String string, List<String> list) {
        List list2 = this.pinService.list((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list3 = list2.stream().map(this.devicePinsApiHelper::toDevicePin).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<CreateDevicePinResult> setDevicePin(CreateDevicePin createDevicePin) {
        SetPinParams setPinParams = this.devicePinsApiHelper.toSetPinParams(createDevicePin);
        CreatePinDTO createPinDTO = this.pinService.set(setPinParams);
        CreateDevicePinResult createDevicePinResult = this.devicePinsApiHelper.toCreateDevicePinResult(createPinDTO);
        return this.ok(createDevicePinResult);
    }

    public ResponseEntity<Void> updateDevicePin(String string, DevicePinEdit devicePinEdit) {
        this.ensureDevicePinKey(string);
        PinDTO pinDTO = this.devicePinsApiHelper.toPinDTO(string, devicePinEdit);
        this.pinService.save(pinDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<InputError> validateDevicePinValue(String string) {
        ValidationResult validationResult = this.pinService.validate(string);
        if (validationResult == null) {
            return ResponseEntity.noContent().build();
        }
        InputError inputError = this.exceptionHelper.toInputError(new ValidationException(validationResult));
        return this.ok(inputError);
    }

    public ResponseEntity<DevicePinView> viewDevicePin(String string, List<String> list) {
        PinDetailedVO pinDetailedVO = this.pinService.locate((PinLocatorVO)ModelHelper.voFromString(PinLocatorVO.class, (String)string));
        return this.ok(this.devicePinsApiHelper.toDevicePinView(pinDetailedVO));
    }

    private void ensureDevicePinKey(String string) {
        if (string == null) {
            throw new ValidationException("Missing device PIN key");
        }
    }
}

