/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodDTO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodData;
import org.cyclos.model.marketplace.webshopdeliverymethods.UserAdDeliveryMethodsListData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.marketplace.AdDeliveryMethodService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.DeliveryMethodsApiHelper;
import org.cyclos.web.rest.model.DeliveryMethodDataForEdit;
import org.cyclos.web.rest.model.DeliveryMethodDataForNew;
import org.cyclos.web.rest.model.DeliveryMethodEdit;
import org.cyclos.web.rest.model.DeliveryMethodNew;
import org.cyclos.web.rest.model.DeliveryMethodView;
import org.cyclos.web.rest.model.UserDeliveryMethodsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class DeliveryMethodsApiImpl
extends BaseApiImpl {
    @Autowired
    private AdDeliveryMethodService adDeliveryMethodService;
    @Autowired
    private DeliveryMethodsApiHelper deliveryMethodsApiHelper;

    public ResponseEntity<String> createDeliveryMethod(String string, DeliveryMethodNew deliveryMethodNew) {
        AdDeliveryMethodDTO adDeliveryMethodDTO = this.deliveryMethodsApiHelper.toAdDeliveryMethodDTO(deliveryMethodNew);
        adDeliveryMethodDTO.setOwner((UserVO)ModelHelper.voFromString(UserVO.class, (String)string));
        String string2 = ApiHelper.toId(this.adDeliveryMethodService.save((EntityDTO)adDeliveryMethodDTO));
        return this.created(this.apiHelper.uriFromApi("delivery-methods", string2), string2);
    }

    public ResponseEntity<Void> deleteDeliveryMethod(String string) {
        this.adDeliveryMethodService.remove(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeliveryMethodDataForEdit> getDeliveryMethodDataForEdit(String string, List<String> list) {
        AdDeliveryMethodData adDeliveryMethodData = (AdDeliveryMethodData)this.adDeliveryMethodService.getData(this.apiHelper.fromId(string));
        DeliveryMethodDataForEdit deliveryMethodDataForEdit = this.deliveryMethodsApiHelper.toDeliveryMethodDataForEdit(adDeliveryMethodData);
        return this.ok(deliveryMethodDataForEdit);
    }

    public ResponseEntity<DeliveryMethodDataForNew> getDeliveryMethodDataForNew(String string, List<String> list) {
        AdDeliveryMethodData adDeliveryMethodData = (AdDeliveryMethodData)this.adDeliveryMethodService.getDataForNew((Object)((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string)));
        DeliveryMethodDataForNew deliveryMethodDataForNew = this.deliveryMethodsApiHelper.toDeliveryMethodDataForNew(adDeliveryMethodData);
        return this.ok(deliveryMethodDataForNew);
    }

    public ResponseEntity<UserDeliveryMethodsListData> getUserDeliveryMethodsListData(String string, List<String> list) {
        UserAdDeliveryMethodsListData userAdDeliveryMethodsListData = this.adDeliveryMethodService.getListData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserDeliveryMethodsListData userDeliveryMethodsListData = this.deliveryMethodsApiHelper.toUserDeliveryMethodsListData(userAdDeliveryMethodsListData);
        return this.ok(userDeliveryMethodsListData);
    }

    public ResponseEntity<Void> updateDeliveryMethod(String string, DeliveryMethodEdit deliveryMethodEdit) {
        AdDeliveryMethodDTO adDeliveryMethodDTO = this.deliveryMethodsApiHelper.toAdDeliveryMethodDTO(deliveryMethodEdit);
        adDeliveryMethodDTO.setId(this.apiHelper.fromId(string));
        this.adDeliveryMethodService.save((EntityDTO)adDeliveryMethodDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeliveryMethodView> viewDeliveryMethod(String string, List<String> list) {
        AdDeliveryMethodData adDeliveryMethodData = (AdDeliveryMethodData)this.adDeliveryMethodService.getData(this.apiHelper.fromId(string));
        DeliveryMethodView deliveryMethodView = this.deliveryMethodsApiHelper.toDeliveryMethodView(adDeliveryMethodData);
        return this.ok(deliveryMethodView);
    }
}

