/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.users.contacts.ContactDTO;
import org.cyclos.model.users.contacts.ContactData;
import org.cyclos.model.users.contacts.ContactDataParams;
import org.cyclos.model.users.contacts.ContactQuery;
import org.cyclos.model.users.contacts.ContactSearchData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserQuery;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.users.ContactService;
import org.cyclos.services.users.UserService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.ContactsApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ContactsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ContactDataForEdit;
import org.cyclos.web.rest.model.ContactDataForNew;
import org.cyclos.web.rest.model.ContactEdit;
import org.cyclos.web.rest.model.ContactListDataForSearch;
import org.cyclos.web.rest.model.ContactListQueryFilters;
import org.cyclos.web.rest.model.ContactNew;
import org.cyclos.web.rest.model.ContactResult;
import org.cyclos.web.rest.model.ContactView;
import org.cyclos.web.rest.model.ContactsQueryFilters;
import org.cyclos.web.rest.model.UserResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ContactsApiImpl
extends BaseApiImpl {
    @Autowired
    private UserService userService;
    @Autowired
    private ContactService contactService;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private ContactsApiHelper contactsApiHelper;

    public ResponseEntity<String> createContact(String string, ContactNew contactNew) {
        ContactDTO contactDTO = this.contactsApiHelper.toContactDTO(null, string, contactNew);
        String string2 = ApiHelper.toId(this.contactService.save((EntityDTO)contactDTO));
        return this.created(this.apiHelper.uriFromApi("contact-list", string2), string2);
    }

    public ResponseEntity<Void> deleteContact(String string) {
        this.contactService.remove(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ContactDataForEdit> getContactDataForEdit(String string, List<String> list) {
        ContactData contactData = (ContactData)this.contactService.getData(this.apiHelper.fromId(string));
        ContactDataForEdit contactDataForEdit = this.contactsApiHelper.toContactDataForEdit(contactData);
        return this.ok(contactDataForEdit);
    }

    public ResponseEntity<ContactDataForNew> getContactListDataForNew(String string, List<String> list, String string2) {
        ContactDataParams contactDataParams = new ContactDataParams();
        contactDataParams.setOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        contactDataParams.setContact((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        ContactData contactData = (ContactData)this.contactService.getDataForNew((Object)contactDataParams);
        ContactDataForNew contactDataForNew = this.contactsApiHelper.toContactDataForNew(string2, contactData);
        return this.ok(contactDataForNew);
    }

    public ResponseEntity<ContactListDataForSearch> getContactListDataForSearch(String string, List<String> list) {
        ContactSearchData contactSearchData = this.contactService.getSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        ContactListDataForSearch contactListDataForSearch = this.contactsApiHelper.toContactListDataForSearch(contactSearchData);
        return this.ok(contactListDataForSearch);
    }

    public ResponseEntity<List<ContactResult>> searchContactList(ContactsApi.SearchContactListParams searchContactListParams) {
        ContactListQueryFilters contactListQueryFilters = (ContactListQueryFilters)ClassHelper.convert((Object)searchContactListParams, ContactListQueryFilters.class);
        ContactQuery contactQuery = this.contactsApiHelper.toContactQuery(searchContactListParams.user, contactListQueryFilters);
        Page page = this.contactService.search(contactQuery);
        return this.pageResponse(page, this.contactsApiHelper::toContactResult);
    }

    public ResponseEntity<List<UserResult>> searchContacts(ContactsApi.SearchContactsParams searchContactsParams) {
        ContactsQueryFilters contactsQueryFilters = (ContactsQueryFilters)ClassHelper.convert((Object)searchContactsParams, ContactsQueryFilters.class);
        UserQuery userQuery = this.usersApiHelper.toContactsQuery(searchContactsParams.user, contactsQueryFilters);
        Page page = this.userService.search(userQuery);
        return this.pageResponse(page, this.usersApiHelper::toUserResult);
    }

    public ResponseEntity<Void> updateContact(String string, ContactEdit contactEdit) {
        ContactDTO contactDTO = this.contactsApiHelper.toContactDTO(string, null, contactEdit);
        this.contactService.save((EntityDTO)contactDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ContactView> viewContact(String string, List<String> list) {
        ContactData contactData = (ContactData)this.contactService.getData(this.apiHelper.fromId(string));
        ContactView contactView = this.contactsApiHelper.toContactView(contactData);
        return this.ok(contactView);
    }
}

