/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ContactInfosApiImpl;
import org.cyclos.web.rest.model.ContactInfoDataForEdit;
import org.cyclos.web.rest.model.ContactInfoDataForNew;
import org.cyclos.web.rest.model.ContactInfoEdit;
import org.cyclos.web.rest.model.ContactInfoNew;
import org.cyclos.web.rest.model.ContactInfoResult;
import org.cyclos.web.rest.model.ContactInfoView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.UserContactInfosListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ContactInfosApi {
    @Autowired
    private ContactInfosApiImpl impl;
    public static final String CREATE_CONTACT_INFO = "/{user}/contact-infos";
    public static final String DELETE_CONTACT_INFO = "/contact-infos/{id}";
    public static final String GET_CONTACT_INFO_DATA_FOR_EDIT = "/contact-infos/{id}/data-for-edit";
    public static final String GET_CONTACT_INFO_DATA_FOR_NEW = "/{user}/contact-infos/data-for-new";
    public static final String GET_PASSWORD_INPUT_FOR_REMOVE_CONTACT_INFO = "/contact-infos/{id}/password-for-remove";
    public static final String GET_USER_CONTACT_INFOS_LIST_DATA = "/{user}/contact-infos/list-data";
    public static final String LIST_CONTACT_INFOS_BY_USER = "/{user}/contact-infos";
    public static final String UPDATE_CONTACT_INFO = "/contact-infos/{id}";
    public static final String VIEW_CONTACT_INFO = "/contact-infos/{id}";

    @RequestMapping(value={"/api/{user:.*}/contact-infos"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createContactInfo(@PathVariable(value="user") String string, @RequestBody(required=true) ContactInfoNew contactInfoNew, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/contact-infos");
        httpServletRequest.setAttribute("errorType", Error.class);
        return this.impl.createContactInfo(string, contactInfoNew, string2);
    }

    @RequestMapping(value={"/api/contact-infos/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteContactInfo(@PathVariable(value="id") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /contact-infos/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteContactInfo(string, string2);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactInfoDataForEdit> getContactInfoDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-infos/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactInfoDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-infos/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactInfoDataForNew> getContactInfoDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-infos/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getContactInfoDataForNew(string, list);
    }

    @RequestMapping(value={"/api/contact-infos/{id}/password-for-remove"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<PasswordInput> getPasswordInputForRemoveContactInfo(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-infos/{id}/password-for-remove");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getPasswordInputForRemoveContactInfo(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-infos/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserContactInfosListData> getUserContactInfosListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-infos/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserContactInfosListData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/contact-infos"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<ContactInfoResult>> listContactInfosByUser(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/contact-infos");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.listContactInfosByUser(string, list);
    }

    @RequestMapping(value={"/api/contact-infos/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateContactInfo(@PathVariable(value="id") String string, @RequestBody(required=true) ContactInfoEdit contactInfoEdit, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /contact-infos/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateContactInfo(string, contactInfoEdit, string2);
    }

    @RequestMapping(value={"/api/contact-infos/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<ContactInfoView> viewContactInfo(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /contact-infos/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewContactInfo(string, list);
    }
}

