/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.messaging.alerts.UserAlertQuery;
import org.cyclos.model.messaging.alerts.UserAlertSearchData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.messaging.AlertService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.AlertsApi;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AlertsApiHelper;
import org.cyclos.web.rest.model.UserAlert;
import org.cyclos.web.rest.model.UserAlertDataForSearch;
import org.cyclos.web.rest.model.UserAlertQueryFilters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AlertsApiImpl
extends BaseApiImpl {
    @Autowired
    private AlertService alertService;
    @Autowired
    private AlertsApiHelper alertsApiHelper;

    public ResponseEntity<UserAlertDataForSearch> getUserAlertDataForSearch(List<String> list) {
        UserAlertSearchData userAlertSearchData = this.alertService.getUserSearchData();
        UserAlertDataForSearch userAlertDataForSearch = this.alertsApiHelper.toUserAlertDataForSearch(userAlertSearchData);
        return this.ok(userAlertDataForSearch);
    }

    public ResponseEntity<List<UserAlert>> searchUserAlerts(AlertsApi.SearchUserAlertsParams searchUserAlertsParams) {
        UserAlertQueryFilters userAlertQueryFilters = (UserAlertQueryFilters)ClassHelper.convert((Object)searchUserAlertsParams, UserAlertQueryFilters.class);
        UserAlertQuery userAlertQuery = this.alertsApiHelper.toUserAlertQuery(userAlertQueryFilters);
        Page page = this.alertService.searchUser(userAlertQuery);
        return this.pageResponse(page, this.alertsApiHelper::toUserAlert);
    }
}

