/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AdInterestsApiImpl;
import org.cyclos.web.rest.model.AdInterestDataForEdit;
import org.cyclos.web.rest.model.AdInterestDataForNew;
import org.cyclos.web.rest.model.AdInterestEdit;
import org.cyclos.web.rest.model.AdInterestNew;
import org.cyclos.web.rest.model.AdInterestView;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.UserAdInterestsListData;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AdInterestsApi {
    @Autowired
    private AdInterestsApiImpl impl;
    public static final String CREATE_AD_INTEREST = "/{user}/marketplace-interests";
    public static final String DELETE_AD_INTEREST = "/marketplace-interests/{id}";
    public static final String GET_AD_INTEREST_DATA_FOR_EDIT = "/marketplace-interests/{id}/data-for-edit";
    public static final String GET_AD_INTEREST_DATA_FOR_NEW = "/{user}/marketplace-interests/data-for-new";
    public static final String GET_USER_AD_INTERESTS_LIST_DATA = "/{user}/marketplace-interests/list-data";
    public static final String UPDATE_AD_INTEREST = "/marketplace-interests/{id}";
    public static final String VIEW_AD_INTEREST = "/marketplace-interests/{id}";

    @RequestMapping(value={"/api/{user:.*}/marketplace-interests"}, produces={"text/plain", "application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<String> createAdInterest(@PathVariable(value="user") String string, @RequestBody(required=true) AdInterestNew adInterestNew, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/marketplace-interests");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.createAdInterest(string, adInterestNew);
    }

    @RequestMapping(value={"/api/marketplace-interests/{id}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> deleteAdInterest(@PathVariable(value="id") String string, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"DELETE /marketplace-interests/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.deleteAdInterest(string);
    }

    @RequestMapping(value={"/api/marketplace-interests/{id}/data-for-edit"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdInterestDataForEdit> getAdInterestDataForEdit(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace-interests/{id}/data-for-edit");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAdInterestDataForEdit(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace-interests/data-for-new"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdInterestDataForNew> getAdInterestDataForNew(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace-interests/data-for-new");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getAdInterestDataForNew(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/marketplace-interests/list-data"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<UserAdInterestsListData> getUserAdInterestsListData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/marketplace-interests/list-data");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserAdInterestsListData(string, list);
    }

    @RequestMapping(value={"/api/marketplace-interests/{id}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> updateAdInterest(@PathVariable(value="id") String string, @RequestBody(required=true) AdInterestEdit adInterestEdit, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /marketplace-interests/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.updateAdInterest(string, adInterestEdit);
    }

    @RequestMapping(value={"/api/marketplace-interests/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<AdInterestView> viewAdInterest(@PathVariable(value="id") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /marketplace-interests/{id}");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.viewAdInterest(string, list);
    }
}

