/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.EnumerationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.RequestEntry;
import org.cyclos.server.utils.RequestMetricsHandler;
import org.cyclos.services.access.ServiceFacade;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="requestDataFilter")
public class RequestDataFilter
extends OncePerRequestFilter {
    public static final String BEAN_NAME = "requestDataFilter";
    private static final Logger LOG = LogManager.getLogger(RequestDataFilter.class);
    private static final List<String> URI_CUSTOM_HEADER_BLACK_LIST = Arrays.asList("/mobile-recaptcha");
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private ServiceFacade serviceFacade;
    @Autowired
    private RequestMetricsHandler requestMetricsHandler;
    private RateLimiter globalRateLimiter;
    private Cache<String, RateLimiter> rateLimitersPerIp;

    public void afterPropertiesSet() throws ServletException {
        int n;
        super.afterPropertiesSet();
        int n2 = this.cyclosProperties.getRateLimitGlobal();
        if (n2 > 0) {
            this.globalRateLimiter = RateLimiter.create((double)n2);
        }
        if ((n = this.cyclosProperties.getRateLimitIp()) > 0) {
            int n3 = Runtime.getRuntime().availableProcessors();
            this.rateLimitersPerIp = CacheBuilder.newBuilder().concurrencyLevel(n3).initialCapacity(n3 * 2).maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        boolean bl;
        Object object2;
        httpServletRequest.setCharacterEncoding("UTF-8");
        String string = this.cyclosProperties.getRemoteAddressHeader();
        int n = this.cyclosProperties.getRemoteAddressHeaderIndex();
        if (string == null) {
            object2 = httpServletRequest.getRemoteAddr();
            bl = false;
        } else {
            object = StringUtils.split((String)httpServletRequest.getHeader(string), (char)',');
            bl = CollectionHelper.isNotEmpty((Object[])object);
            if (!bl) {
                object2 = httpServletRequest.getRemoteAddr();
            } else {
                if (n >= ((Object[])object).length || n < 0 && Math.abs(n) > ((Object[])object).length) {
                    httpServletResponse.sendError(400);
                    return;
                }
                object2 = object[n < 0 ? ((Object[])object).length + n : n];
                object2 = StringUtils.trim((String)object2);
            }
        }
        ServletHelper.setProxied(httpServletRequest, bl);
        String string2 = this.cyclosProperties.getProtocolHeader();
        if (string2 == null) {
            object = httpServletRequest.getScheme();
        } else {
            object = StringHelper.trimToNull((Object)httpServletRequest.getHeader(string2));
            if (object == null) {
                object = httpServletRequest.getScheme();
            }
        }
        object = StringHelper.removeEnd((String)object, (String)"://");
        String string3 = ServletHelper.getInternalUri(httpServletRequest);
        RequestEntry requestEntry = new RequestEntry((String)object2, httpServletRequest, string3, (String)object, bl);
        long l = this.requestMetricsHandler.started(requestEntry);
        try {
            this.applyRateLimit((String)object2);
            this.doFilter(httpServletRequest, httpServletResponse, filterChain, requestEntry);
        }
        finally {
            this.requestMetricsHandler.finished(l);
        }
    }

    private void applyRateLimit(String string) {
        double d;
        String string2 = this.cyclosProperties.getRateLimitWhitelist();
        boolean bl = true;
        if (string2 != null) {
            boolean bl2 = bl = !string2.contains(string);
        }
        if (!bl) {
            return;
        }
        if (this.rateLimitersPerIp != null) {
            RateLimiter rateLimiter;
            try {
                rateLimiter = (RateLimiter)this.rateLimitersPerIp.get((Object)string, () -> RateLimiter.create((double)this.cyclosProperties.getRateLimitIp()));
            }
            catch (ExecutionException executionException) {
                throw new IllegalStateException(executionException);
            }
            double d2 = rateLimiter.acquire();
            if (d2 > 0.0 && LOG.isDebugEnabled()) {
                LOG.debug("Request from " + string + " was delayed by " + d2 + " by IP rate limit");
            }
        }
        if (this.globalRateLimiter != null && (d = this.globalRateLimiter.acquire()) > 0.0 && LOG.isDebugEnabled()) {
            LOG.debug("Request from " + string + " was delayed by " + d + " by global rate limit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain, RequestEntry requestEntry) throws IOException, ServletException {
        URL uRL;
        String string3 = requestEntry.getUri();
        String string4 = requestEntry.getStaticUri();
        if (string4 == null) {
            List list;
            uRL = this.getRootUrl(httpServletRequest);
            RequestData requestData = this.serviceFacade.resolveRequestData(requestEntry.isProxy(), requestEntry.getProtocol(), requestEntry.getRemoteAddress(), uRL.toString(), string3);
            requestEntry.setRequestData(requestData);
            httpServletRequest.setAttribute("requestData", (Object)requestData);
            List list2 = Collections.emptyList();
            String[] stringArray = httpServletRequest.getParameterValues("fields");
            if (stringArray != null) {
                list2 = Stream.of(stringArray).flatMap(string -> StringHelper.splitTrimming((String)string, (String)",").stream()).collect(Collectors.toList());
            }
            requestData.setFields(FieldSelector.of(list2));
            String string5 = ServletHelper.getPreferredLocale(httpServletRequest);
            if (StringHelper.isNotBlank((Object)string5)) {
                list = Collections.singletonList(string5);
            } else {
                List list3 = EnumerationUtils.toList((Enumeration)httpServletRequest.getLocales());
                list = CoercionHelper.coerceList(String.class, (Object)list3);
            }
            requestData.setLocales(list);
            requestData.setRequestInfo(ServletHelper.toRequestInfo(httpServletRequest));
            ServletHelper.CURRENT_REQUEST_DATA.set(requestData);
            if (!URI_CUSTOM_HEADER_BLACK_LIST.contains(requestData.getUri())) {
                this.responseHeaders().forEach((string, string2) -> httpServletResponse.setHeader(string, string2));
            }
            if ((string4 = requestData.getUri()).equals("/")) {
                string4 = "/index";
            }
        }
        try {
            if (string4.startsWith("/api/") || string4.startsWith("/web-rpc/") || string4.startsWith("/content/")) {
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            }
            if (string4.equals(string3)) {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                uRL = httpServletRequest.getRequestDispatcher(string4);
                if (uRL == null) {
                    httpServletResponse.sendError(404);
                } else {
                    uRL.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                }
            }
        }
        finally {
            ServletHelper.CURRENT_REQUEST_DATA.remove();
        }
    }

    private URL getRootUrl(HttpServletRequest httpServletRequest) {
        int n = httpServletRequest.getServerPort();
        String string = httpServletRequest.getScheme();
        if ("https".equals(string) && n == 443 || "http".equals(string) && n == 80) {
            n = -1;
        }
        try {
            return new URL(string, httpServletRequest.getServerName(), n, httpServletRequest.getContextPath());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException("Invalid URL from request?", malformedURLException);
        }
    }

    private Map<String, String> responseHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("x-frame-options", "SAMEORIGIN");
        hashMap.put("x-xss-protection", "1; mode=block");
        hashMap.putAll(this.cyclosProperties.getResponseHeaders());
        return hashMap;
    }
}

