/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.CyclosException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.reports.SystemReportQuery;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.system.ReportService;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ReportsController
extends BaseController {
    @Autowired
    private ReportService reportService;

    @PostMapping(value={"/content/reports/system"})
    public void systemReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="query") String string) throws IOException {
        try {
            SystemReportQuery systemReportQuery = (SystemReportQuery)this.jsonConverter.readValue(string, SystemReportQuery.class);
            SerializableInputStream serializableInputStream = this.reportService.readSystemReport(systemReportQuery);
            String string2 = this.message(SystemKeys.Reports.SYSTEM_HEADING, new Object[0]);
            String string3 = systemReportQuery.getPeriod() != null ? " - " + String.valueOf(systemReportQuery.getPeriod()) : "";
            ServletHelper.writePDFContents(httpServletResponse, string2 + string3 + ".pdf", (InputStream)serializableInputStream);
        }
        catch (CyclosException cyclosException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, cyclosException);
        }
    }
}

