/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.cyclos.impl.system.InternalImageServiceImpl;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.utils.ContentType;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.rest.model.Image;

public class ImageContentResolver
extends InlineCacheableContentResolver {
    public static final Pattern KEY_PATTERN = Pattern.compile("([a-zA-Z0-9]+)_(\\d+)x(\\d+)\\.([a-z]+)");
    private static final int THUMBNAIL_JPEG_QUALITY = 95;
    private CyclosProperties cyclosProperties;
    private InternalImageService imageService;
    private String key;
    private String keyPrefix;
    private String extension;
    private int width;
    private int height;
    private File file;

    public ImageContentResolver(CyclosProperties cyclosProperties, InternalImageService internalImageService, String string, Integer n, Integer n2) {
        Object object;
        int n3;
        int n4;
        this.cyclosProperties = cyclosProperties;
        this.imageService = internalImageService;
        if (n != null && n <= 0 || n2 != null && n2 <= 0) {
            throw new EntityNotFoundException();
        }
        this.key = string;
        boolean bl = string.startsWith(InternalImageServiceImpl.SYSTEM_IMAGE_URL_TOKEN);
        this.setLongCache(!bl);
        Matcher matcher = KEY_PATTERN.matcher(string);
        if (matcher.find()) {
            if (!ServerImageHelper.ImageType.hasImageExtension((String)string)) {
                throw new EntityNotFoundException();
            }
            this.keyPrefix = matcher.group(1);
            n4 = Integer.parseInt(matcher.group(2));
            n3 = Integer.parseInt(matcher.group(3));
            this.extension = matcher.group(4);
        } else if (bl) {
            object = internalImageService.loadByKey(string);
            this.keyPrefix = object.getKey();
            n4 = object.getWidth();
            n3 = object.getHeight();
            this.extension = ServerImageHelper.ImageType.getByContentType((String)object.getContentType()).getExtension();
        } else {
            throw new EntityNotFoundException(Image.class, string);
        }
        object = ServerImageHelper.getActualSize((Dimension)new Dimension(n4, n3), (Integer)n, (Integer)n2);
        this.width = (int)((Dimension)object).getWidth();
        this.height = (int)((Dimension)object).getHeight();
        String string2 = this.keyPrefix + "_" + this.width + "x" + this.height + "." + this.extension;
        this.file = new File(this.imageDir(), string2);
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.getByExtension((String)this.extension);
    }

    @Override
    protected File resolveFile() throws IOException {
        return this.file;
    }

    @Override
    protected File resolveGZipFile(File file) {
        return null;
    }

    @Override
    protected Long resolveLastModification() {
        try {
            return this.writeOriginal().lastModified();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected void writeContent(File file) throws IOException {
        File file2 = this.writeOriginal();
        if (!file2.equals(file)) {
            BufferedImage bufferedImage = ImageIO.read(file2);
            bufferedImage = ServerImageHelper.resize((BufferedImage)bufferedImage, (int)this.width, (int)this.height);
            ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.getByFileName((String)file.getName()), (File)file, (int)95);
            file.setLastModified(file2.lastModified());
        }
    }

    private File imageDir() {
        File file = new File(this.cyclosProperties.getTempDir(), "images");
        file.mkdirs();
        return file;
    }

    private File writeOriginal() throws IOException {
        File file = new File(this.imageDir(), this.key);
        if (!file.exists() || file.length() == 0L) {
            file.getParentFile().mkdirs();
            SerializableInputStream serializableInputStream = this.imageService.readContentByKey(this.key);
            IOHelper.copyAndClose((InputStream)serializableInputStream, (File)file);
        }
        return file;
    }
}

