/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.push;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.ValidationException;
import org.cyclos.model.utils.PushNotificationEvent;
import org.cyclos.model.utils.PushNotificationEventFilter;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.web.utils.SseEmitterHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Controller
public class PushNotificationController {
    public static final Logger LOG = LogManager.getLogger(PushNotificationController.class);
    @Autowired
    private SseEmitterHandler sseEmitterHandler;

    @GetMapping(value={"/push-notifications"})
    public SseEmitter subscribe(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="clientId") String string, @RequestParam(name="ticketNumber", required=false) String string2, @RequestParam(name="deviceConfirmationId", required=false) String string3, @RequestParam(name="identityProviderRequestId", required=false) String string4, @RequestParam(value="eventTypes") Set<String> set) throws IOException {
        if (set == null) {
            throw new ValidationException("No event types specified");
        }
        Set set2 = set.stream().map(PushNotificationEventType::getByName).filter(Objects::nonNull).collect(Collectors.toSet());
        PushNotificationEventFilter pushNotificationEventFilter = new PushNotificationEventFilter();
        pushNotificationEventFilter.setTypes(set2);
        pushNotificationEventFilter.setTicketNumber(string2);
        pushNotificationEventFilter.setDeviceConfirmationId(string3);
        pushNotificationEventFilter.setIdentityProviderRequestId(string4);
        return this.sseEmitterHandler.subscribe(httpServletRequest, httpServletResponse, string, pushNotificationEventFilter, PushNotificationEvent::getData);
    }
}

