/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.mobile;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.services.mobile.InternalMobileService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MobileController {
    @Autowired
    private InternalMobileService internalMobilService;

    @GetMapping(value={"/mobile-recaptcha"})
    public ModelAndView reCaptcha(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ModelAndView modelAndView = new ModelAndView("recaptcha");
        modelAndView.addObject("siteKey", (Object)this.internalMobilService.getRecaptchaKey());
        return modelAndView;
    }

    @RequestMapping(value={"/mobile-redirect/*"})
    public void redirectLink(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer(StringUtils.substringAfter((String)httpServletRequest.getRequestURI(), (String)"/mobile-redirect"));
        StringBuffer stringBuffer2 = new StringBuffer();
        for (String string : CollectionHelper.iterable((Enumeration)httpServletRequest.getParameterNames())) {
            if (stringBuffer2.length() > 0) {
                stringBuffer2.append("&");
            }
            stringBuffer2.append(string).append("=").append(StringUtils.join((Object[])httpServletRequest.getParameterValues(string), (String)","));
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("?").append(stringBuffer2.toString());
        }
        try {
            httpServletResponse.sendRedirect(this.internalMobilService.generateLinkForMobile(stringBuffer.toString()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error redirecting to mobile app url", iOException);
        }
    }
}

