/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.contentmanagement;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Submodules;
import org.cyclos.model.contentmanagement.translations.SetCustomizedTranslationsDTO;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.services.contentmanagement.TranslationMessageService;
import org.cyclos.services.system.LanguageService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.CacheableContentResolver;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class TranslationMessagesController
extends BaseController {
    @Autowired
    private TranslationMessageService translationMessageService;
    @Autowired
    private LanguageService languageService;
    @Autowired
    private JsonConverter jsonConverter;

    @PostMapping(value={"/content/translations/export"})
    public void exportCustomizedKeys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="id") Long l) throws IOException {
        LanguageDetailedVO languageDetailedVO = this.languageService.get(new LanguageVO(l));
        new CustomizedKeysContentResolver(languageDetailedVO).write(httpServletRequest, httpServletResponse);
    }

    @PostMapping(value={"/content/translations/import"})
    public void importCustomizedKeys(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="id") Long l, @RequestParam(value="file") MultipartFile multipartFile) throws UnsupportedEncodingException, IOException {
        try {
            Properties properties = PropertiesHelper.from((InputStream)multipartFile.getInputStream());
            Map map = PropertiesHelper.asMap((Properties)properties);
            SetCustomizedTranslationsDTO setCustomizedTranslationsDTO = new SetCustomizedTranslationsDTO();
            setCustomizedTranslationsDTO.setLanguage(new LanguageVO(l));
            setCustomizedTranslationsDTO.setTranslations(map);
            this.translationMessageService.setCustomizedKeysPerLanguage(setCustomizedTranslationsDTO);
            ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, null);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @GetMapping(value={"/content/translations/load"})
    public void loadTranslations(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="submodule") String[] languageDetailedVO) throws IOException {
        LanguageDetailedVO languageDetailedVO2;
        HashSet<Submodule> hashSet = new HashSet<Submodule>();
        for (String string : languageDetailedVO) {
            Submodule submodule = Submodules.from((String)StringHelper.replace((String)string, (String)"\"", (String)""));
            hashSet.add(submodule);
        }
        try {
            languageDetailedVO2 = this.languageService.getCurrent();
        }
        catch (FrameworkException frameworkException) {
            httpServletResponse.setStatus(403);
            return;
        }
        new TranslationsContentResolver(languageDetailedVO2, hashSet).write(httpServletRequest, httpServletResponse);
    }

    private class CustomizedKeysContentResolver
    extends CacheableContentResolver {
        private LanguageDetailedVO language;

        public CustomizedKeysContentResolver(LanguageDetailedVO languageDetailedVO) {
            this.language = languageDetailedVO;
        }

        @Override
        protected String resolveAttachmentName() throws IOException {
            return "CyclosCustomizedKeys_" + this.language.getName() + ".properties";
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.TEXT;
        }

        @Override
        protected File resolveFile() throws IOException {
            return new File(TranslationMessagesController.this.getTempDir("customizedKeys"), "customizedKeys_" + this.language.getId() + ".properties");
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            return StringHelper.isBlank((Object)this.language.getLastModifiedInMillis()) ? null : Long.valueOf(this.language.getLastModifiedInMillis());
        }

        @Override
        protected void writeContent(File file) throws IOException {
            Properties properties = TranslationMessagesController.this.translationMessageService.getCustomizedKeysPerLanguage((LanguageVO)this.language);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                properties.store(outputStreamWriter, "Cyclos customized translation keys for language: " + this.language.getName());
            }
        }
    }

    private class TranslationsContentResolver
    extends InlineCacheableContentResolver {
        private LanguageDetailedVO language;
        private Set<Submodule> submodules;
        private SortedSet<Integer> submoduleIds;

        public TranslationsContentResolver(LanguageDetailedVO languageDetailedVO, Set<Submodule> set) {
            this.language = languageDetailedVO;
            this.submodules = set;
            this.submoduleIds = new TreeSet<Integer>();
            for (Submodule submodule : set) {
                this.submoduleIds.add(Submodules.getId((Submodule)submodule));
            }
            this.setLongCache(true);
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.JSON;
        }

        @Override
        protected File resolveFile() throws IOException {
            return new File(TranslationMessagesController.this.getTempDir("translations"), this.language.getId() + "_" + StringHelper.join(this.submoduleIds, (String)"_"));
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            return StringHelper.isBlank((Object)this.language.getLastModifiedInMillis()) ? null : Long.valueOf(this.language.getLastModifiedInMillis());
        }

        @Override
        protected void writeContent(File file) throws IOException {
            TranslationsData translationsData = TranslationMessagesController.this.internalTranslationMessageService.getBySubmodules(this.submodules);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
                TranslationMessagesController.this.jsonConverter.writeValue((Writer)outputStreamWriter, (Object)translationsData.getTranslations());
            }
        }
    }
}

