/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.contentmanagement;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.contentmanagement.themes.NewThemeImageParams;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.contentmanagement.themes.ThemeVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.contentmanagement.ThemeImageService;
import org.cyclos.services.contentmanagement.ThemeService;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.InlineCacheableContentResolver;
import org.cyclos.web.controllers.contentmanagement.CSSContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ThemesController
extends BaseController {
    private static final int THUMBNAIL_JPEG_QUALITY = 100;
    @Autowired
    private ThemeService themeService;
    @Autowired
    private ThemeImageService themeImageService;
    @Autowired
    private InternalImageService internalImageService;

    @PostMapping(value={"/content/themes/{id:.*}"})
    public void exportTheme(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws IOException {
        FileInfo fileInfo = this.themeService.export(l);
        ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
    }

    @GetMapping(value={"/content/themes/{id}.css"})
    public void getCssContents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l) throws IOException {
        ServletHelper.forceGuest(httpServletRequest);
        ThemeVO themeVO = this.themeService.getVO(l);
        CSSContentResolver cSSContentResolver = new CSSContentResolver(this.cyclosProperties, this.themeService, themeVO, this.getTempDir("themes"));
        if (!this.cyclosProperties.isDevelopment()) {
            cSSContentResolver.setLongCache(true);
        }
        cSSContentResolver.write(httpServletRequest, httpServletResponse);
    }

    @GetMapping(value={"/content/themes/{id}/image"})
    public void getImageContents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @RequestParam(name="type", defaultValue="CUSTOM") ThemeImageType themeImageType, @RequestParam(value="name") String string, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws IOException {
        ServletHelper.forceGuest(httpServletRequest);
        ThemeImageVO themeImageVO = this.themeImageService.getImageVO(l, themeImageType, string);
        try {
            new ImageContentResolver(l, themeImageVO, n, n2).write(httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @PostMapping(value={"/content/themes"})
    public void importTheme(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="configurationId") Long l) throws IOException {
        try {
            Long l2 = this.themeService.importNew(new ConfigurationVO(l), multipartFile.getOriginalFilename(), new SerializableInputStream(multipartFile.getInputStream()));
            ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, "id", l2);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/themes/{id}/image"})
    public void saveImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="id") Long l, @RequestParam(name="type", defaultValue="CUSTOM") ThemeImageType themeImageType, @RequestParam(name="name", required=false) String string) throws Exception {
        ServerImageHelper.ImageType imageType;
        if (StringHelper.isBlank((Object)string)) {
            string = multipartFile.getOriginalFilename();
        }
        try {
            imageType = ServerImageHelper.ImageType.getByContentType((String)multipartFile.getContentType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, illegalArgumentException);
            return;
        }
        NewThemeImageParams newThemeImageParams = new NewThemeImageParams();
        newThemeImageParams.setThemeId(l);
        newThemeImageParams.setType(themeImageType);
        ImageVO imageVO = this.themeImageService.save((Object)newThemeImageParams, string, new SerializableInputStream(multipartFile.getInputStream()), imageType.getContentType());
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("id", imageVO.getId());
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, hashMap);
    }

    private class ImageContentResolver
    extends InlineCacheableContentResolver {
        private Long themeId;
        private ThemeImageVO image;
        private Integer width;
        private Integer height;

        public ImageContentResolver(Long l, ThemeImageVO themeImageVO, Integer n, Integer n2) {
            this.themeId = l;
            this.image = themeImageVO;
            Dimension dimension = new Dimension(themeImageVO.getWidth(), themeImageVO.getHeight());
            Dimension dimension2 = ServerImageHelper.getActualSize((Dimension)dimension, (Integer)n, (Integer)n2);
            if (!dimension.equals(dimension2)) {
                this.width = (int)dimension2.getWidth();
                this.height = (int)dimension2.getHeight();
            }
        }

        @Override
        protected ContentType resolveContentType() throws IOException {
            return ContentType.getByMimeType((String)this.image.getContentType());
        }

        @Override
        protected File resolveFile() throws IOException {
            String string = this.hasResizeDimensions() ? "_" + this.width + "x" + this.height : "";
            return new File(ThemesController.this.getTempDir("images/THEME"), this.themeId + "/" + String.valueOf(this.image.getType()) + "/" + (this.image.isCustomized() ? "custom" : "original") + "/" + this.image.getName() + string);
        }

        @Override
        protected Long resolveLastModification() throws IOException {
            String string = this.image.getLastModifiedInMillis();
            return StringHelper.isBlank((Object)string) ? null : Long.valueOf(string);
        }

        @Override
        protected void writeContent(File file) throws IOException {
            SerializableInputStream serializableInputStream = ThemesController.this.internalImageService.readThemeImage(this.themeId, this.image.getType(), this.image.getName());
            IOHelper.copyAndClose((InputStream)serializableInputStream, (File)file);
            if (this.hasResizeDimensions()) {
                BufferedImage bufferedImage = ImageIO.read(file);
                bufferedImage = ServerImageHelper.resize((BufferedImage)bufferedImage, (int)this.width, (int)this.height);
                ServerImageHelper.write((BufferedImage)bufferedImage, (ServerImageHelper.ImageType)ServerImageHelper.ImageType.getByContentType((String)this.image.getContentType()), (File)file, (int)100);
            }
        }

        private boolean hasResizeDimensions() {
            return this.width != null;
        }
    }
}

