/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers;

import com.google.common.util.concurrent.Striped;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.web.utils.RequestHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class CacheableContentResolver {
    private static Striped<Lock> LOCKS = Striped.lock((int)Math.max(16, Runtime.getRuntime().availableProcessors()));
    private boolean longCache;

    public boolean isLongCache() {
        return this.longCache;
    }

    public void setLongCache(boolean bl) {
        this.longCache = bl;
    }

    public File write(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        for (int i = 0; i < 10; ++i) {
            try {
                return this.doWrite(httpServletRequest, httpServletResponse);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        return null;
    }

    protected abstract String resolveAttachmentName() throws IOException;

    protected abstract ContentType resolveContentType() throws IOException;

    protected abstract File resolveFile() throws IOException;

    protected File resolveGZipFile(File file) {
        return new File(file.getAbsolutePath() + ".gz");
    }

    protected abstract Long resolveLastModification() throws IOException;

    protected abstract void writeContent(File var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File doWrite(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)httpServletRequest.getServletContext());
        CyclosProperties cyclosProperties = (CyclosProperties)webApplicationContext.getBean(CyclosProperties.class);
        File file = this.resolveFile();
        File file2 = this.resolveGZipFile(file);
        Long l = this.resolveLastModification();
        if (l != null) {
            l = l / 1000L * 1000L;
        }
        boolean bl = false;
        if (cyclosProperties.isDevelopment() || !file.exists() || l == null || l > file.lastModified()) {
            bl = true;
        }
        if (cyclosProperties.isDevelopment()) {
            ServletHelper.setNoCache(httpServletResponse);
        } else if (this.longCache) {
            ServletHelper.setLongCache(httpServletResponse);
        } else if (l != null) {
            ServletHelper.setUseCache(httpServletResponse);
        }
        if (bl) {
            Lock lock = (Lock)LOCKS.get((Object)file.getAbsolutePath());
            try {
                if (!lock.tryLock(1L, TimeUnit.SECONDS)) {
                    throw new LockAcquisitionException();
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            try {
                file.getParentFile().mkdirs();
                this.writeContent(file);
                if (l != null) {
                    file.setLastModified(l);
                }
                if (file2 != null) {
                    IOHelper.copyAndClose((InputStream)new FileInputStream(file), (OutputStream)new GZIPOutputStream(new FileOutputStream(file2)));
                    file2.setLastModified(file.lastModified());
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (bl || RequestHelper.wasModified(httpServletRequest, file.lastModified())) {
            ServletHelper.writeFileContents(httpServletRequest, httpServletResponse, this.resolveContentType(), file, file2, this.resolveAttachmentName());
        } else {
            httpServletResponse.setStatus(304);
        }
        return file;
    }
}

