/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app.ui;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.server.model.app.WebManifestData;
import org.cyclos.services.app.InternalFrontendService;
import org.cyclos.web.app.AngularAppController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/ui"})
public class UiController
extends AngularAppController {
    public static final String APP_ID = "ui";
    @Autowired
    private InternalFrontendService internalFrontendService;

    @Override
    public ModelAndView index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        RequestData requestData = ServletHelper.getRequestData();
        ServletHelper.forceGuest(httpServletRequest);
        ServletHelper.setNoCache(httpServletResponse);
        return new ModelAndView(APP_ID).addObject("meta", (Object)this.meta()).addObject("styleUrl", (Object)this.styleUrl(requestData)).addObject("fontCssUrl", (Object)this.fontCssUrl(requestData)).addObject("rootUrl", (Object)this.rootUrl(requestData)).addObject("base", (Object)this.base(requestData));
    }

    @RequestMapping(value={"/offline"})
    public ModelAndView offline(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return ServletHelper.showError(this.message(GeneralKeys.Errors.NETWORK_CONNECTION, new Object[0]));
    }

    @RequestMapping(value={"", "/"})
    public ModelAndView root(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.index(httpServletRequest, httpServletResponse);
    }

    @RequestMapping(value={"/manifest.webmanifest"})
    @ResponseBody
    public WebManifestData webManifest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.internalFrontendService.getWebManifestData(true);
    }

    @Override
    protected String getAppId() {
        return APP_ID;
    }

    @Override
    protected String meta() {
        return super.meta() + "\n<link rel=\"manifest\" href=\"manifest.webmanifest\">";
    }
}

