/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app.consent;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.oidcclients.BaseOidcClientDTO;
import org.cyclos.model.access.oidcclients.DynamicOidcClientDTO;
import org.cyclos.model.access.oidcclients.OidcClientDTO;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.access.oidcclients.ScopeVO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.server.model.access.oidc.AuthorizeResponse;
import org.cyclos.server.model.access.oidc.ConsentData;
import org.cyclos.server.model.access.oidc.ConsentParams;
import org.cyclos.services.access.OidcService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.URIHelper;
import org.cyclos.web.app.AngularAppController;
import org.cyclos.web.app.consent.OidcClient;
import org.cyclos.web.app.consent.OidcDataForConsent;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.OidcApiHelper;
import org.cyclos.web.rest.model.OidcAuthorizeResult;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/consent"})
public class ConsentController
extends AngularAppController {
    public static final String APP_ID = "consent";
    public static final Logger LOG = LogManager.getLogger(ConsentController.class);
    @Autowired
    private OidcService oidcService;
    @Autowired
    private OidcApiHelper oidcApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    @PostMapping(value={"approve/{locator}"})
    public ResponseEntity<OidcAuthorizeResult> approve(@PathVariable(value="locator") String string, @RequestParam(value="user") String string2, @RequestParam(value="password") String string3) {
        ConsentParams consentParams = new ConsentParams();
        consentParams.setLocator(string);
        consentParams.setUser(StringHelper.decodeURIComponent((String)string2));
        consentParams.setPassword(StringHelper.decodeURIComponent((String)string3));
        AuthorizeResponse authorizeResponse = this.oidcService.approve(consentParams);
        OidcAuthorizeResult oidcAuthorizeResult = this.oidcApiHelper.toOidcAuthorizeResult(authorizeResponse);
        return this.ok(oidcAuthorizeResult);
    }

    @PostMapping(value={"deny/{locator}"})
    public ResponseEntity<OidcAuthorizeResult> deny(@PathVariable(value="locator") String string) {
        AuthorizeResponse authorizeResponse = this.oidcService.deny(string);
        OidcAuthorizeResult oidcAuthorizeResult = this.oidcApiHelper.toOidcAuthorizeResult(authorizeResponse);
        return this.ok(oidcAuthorizeResult);
    }

    @GetMapping(value={"data/{locator}"})
    public ResponseEntity<OidcDataForConsent> getData(@PathVariable(value="locator") String string) throws IOException, ServletException {
        ConsentData consentData = this.oidcService.getConsentData(string);
        OidcDataForConsent oidcDataForConsent = this.toOidcDataForConsent(consentData);
        return this.ok(oidcDataForConsent);
    }

    @Override
    public ModelAndView index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = (String)CollectionHelper.last((List)StringHelper.splitTrimming((String)httpServletRequest.getRequestURI(), (String)"/"));
        ServletHelper.forceGuest(httpServletRequest);
        ServletHelper.setNoCache(httpServletResponse);
        ConsentData consentData = null;
        try {
            consentData = this.oidcService.getConsentData(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RequestData requestData = ServletHelper.getRequestData();
        return new ModelAndView(APP_ID).addObject("meta", (Object)this.meta()).addObject("apiRoot", (Object)this.rootUrl(requestData)).addObject("base", (Object)this.base(requestData)).addObject("data", (Object)this.toOidcDataForConsent(consentData)).addObject("styleUrl", (Object)this.styleUrl(requestData));
    }

    @RequestMapping(value={"", "/"})
    public ModelAndView root(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.index(httpServletRequest, httpServletResponse);
    }

    @Override
    protected String getAppId() {
        return APP_ID;
    }

    @Override
    protected boolean useAppStyle() {
        return false;
    }

    private <T> ResponseEntity<T> ok(T t) {
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body(t);
    }

    private OidcClient toOidcClient(BaseOidcClientDTO baseOidcClientDTO) {
        OidcClient oidcClient = this.apiHelper.newEntity(OidcClient.class, baseOidcClientDTO);
        oidcClient.setDescription(baseOidcClientDTO.getDescription());
        oidcClient.setWebsite(baseOidcClientDTO.getWebsite());
        oidcClient.setPrivacyPolicyUrl(baseOidcClientDTO.getPrivacyPolicyUrl());
        oidcClient.setTermsOfServiceUrl(baseOidcClientDTO.getTermsOfServiceUrl());
        if (baseOidcClientDTO instanceof DynamicOidcClientDTO) {
            DynamicOidcClientDTO dynamicOidcClientDTO = (DynamicOidcClientDTO)baseOidcClientDTO;
            oidcClient.setDynamic(true);
            oidcClient.setImageUrl(dynamicOidcClientDTO.getImageUrl());
            String string = (String)CollectionHelper.first((Iterable)StringHelper.splitTrimming((String)dynamicOidcClientDTO.getRedirectUris(), (String)"\n"));
            oidcClient.setDomain(URIHelper.getDomain((URI)URIHelper.of((String)string)));
        } else if (baseOidcClientDTO instanceof OidcClientDTO) {
            OidcClientDTO oidcClientDTO = (OidcClientDTO)baseOidcClientDTO;
            oidcClient.setImage(this.imagesApiHelper.toImage(oidcClientDTO.getImage()));
        }
        return oidcClient;
    }

    private OidcDataForConsent toOidcDataForConsent(ConsentData consentData) {
        if (consentData == null) {
            return null;
        }
        OidcDataForConsent oidcDataForConsent = new OidcDataForConsent();
        oidcDataForConsent.setClient(this.toOidcClient(consentData.getClient()));
        CollectionHelper.orEmpty((List)consentData.getScopes()).stream().map(ScopeVO::getDisplay).filter(StringHelper::isNotBlank).forEach(oidcDataForConsent.getScopes()::add);
        oidcDataForConsent.setOpenidOnly(consentData.getScopes().size() == 1 && ((ScopeVO)consentData.getScopes().get(0)).getScope() == Scope.OPENID);
        oidcDataForConsent.setOfflineAccess(consentData.getScopes().stream().anyMatch(scopeVO -> scopeVO.getScope() == Scope.OFFLINE_ACCESS));
        oidcDataForConsent.setExpiresAfter(consentData.getExpiresAfter());
        oidcDataForConsent.setAccountType(consentData.getAccountType());
        oidcDataForConsent.setPaymentTo(consentData.getPaymentTo());
        oidcDataForConsent.setPaymentAmount(consentData.getPaymentAmount());
        oidcDataForConsent.setSinglePayment(consentData.isSinglePayment());
        oidcDataForConsent.setLoginHint(consentData.getLoginHint());
        oidcDataForConsent.setLocale(consentData.getLocale());
        oidcDataForConsent.setCountry(consentData.getCountry());
        oidcDataForConsent.setShortcutIcon(this.imagesApiHelper.toImage(consentData.getShortcutIcon()));
        oidcDataForConsent.setApplicationName(consentData.getApplicationName());
        oidcDataForConsent.setApplicationLogo(this.imagesApiHelper.toImage(consentData.getApplicationLogo()));
        oidcDataForConsent.setPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)consentData.getPasswordInput()));
        return oidcDataForConsent;
    }
}

