/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.app;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.contentmanagement.InternalTranslationMessageService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.InlineCacheableContentResolver;

public class I18nContentResolver
extends InlineCacheableContentResolver {
    private final CyclosProperties cyclosProperties;
    private final InternalTranslationMessageService internalTranslationMessageService;
    private final JsonConverter jsonConverter;
    private final LanguageDetailedVO language;
    private final File tempDir;

    public I18nContentResolver(CyclosProperties cyclosProperties, InternalTranslationMessageService internalTranslationMessageService, JsonConverter jsonConverter, LanguageDetailedVO languageDetailedVO, File file) {
        this.cyclosProperties = cyclosProperties;
        this.internalTranslationMessageService = internalTranslationMessageService;
        this.jsonConverter = jsonConverter;
        this.language = languageDetailedVO;
        this.tempDir = file;
    }

    @Override
    protected ContentType resolveContentType() throws IOException {
        return ContentType.JSON;
    }

    @Override
    protected File resolveFile() throws IOException {
        return new File(this.tempDir, this.language.getId() + "_i18n.json");
    }

    @Override
    protected Long resolveLastModification() throws IOException {
        if (this.cyclosProperties.isDevelopment()) {
            return null;
        }
        return StringHelper.isBlank((Object)this.language.getLastModifiedInMillis()) ? null : Long.valueOf(this.language.getLastModifiedInMillis());
    }

    @Override
    protected void writeContent(File file) throws IOException {
        TranslationsData translationsData = this.internalTranslationMessageService.getAppI18n();
        Map map = translationsData.getTranslations();
        Map map2 = CollectionHelper.nestKeys((Map)map, (String)"-");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charsets.UTF_8);){
            this.jsonConverter.writeValue((Writer)outputStreamWriter, (Object)map2);
        }
    }
}

