/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.EnumSet;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.users.ChangeUserStatusData;
import org.cyclos.model.users.users.ChangeUserStatusParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.services.users.UserStatusService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserStatusServiceSecurity
extends BaseServiceSecurity
implements UserStatusService {
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;

    public void changeStatus(ChangeUserStatusParams changeUserStatusParams) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changeUserStatusParams.getUser());
        if (basicUser instanceof Operator) {
            if (!this.operatorServiceSecurity.canManageOperators(basicUser.getUser())) {
                throw new PermissionDeniedException();
            }
        } else {
            EnumSet<UserStatus> enumSet = EnumSet.of(basicUser.getStatus());
            UserStatus userStatus = changeUserStatusParams.getStatus();
            if (userStatus != null) {
                enumSet.add(userStatus);
            }
            enumSet.remove(UserStatus.ACTIVE);
            for (UserStatus userStatus2 : enumSet) {
                switch (userStatus2) {
                    case BLOCKED: {
                        this.checkPermission(Permission.BLOCKED_USERS_MANAGE);
                        break;
                    }
                    case DISABLED: {
                        this.checkPermission(Permission.DISABLED_USERS_MANAGE);
                        break;
                    }
                    case REMOVED: {
                        this.checkPermission(Permission.REMOVED_USERS_MANAGE);
                        break;
                    }
                    case PURGED: {
                        this.checkPermission(Permission.PURGED_USERS_MANAGE);
                        break;
                    }
                }
            }
        }
        this.userStatusService.changeStatus(changeUserStatusParams);
    }

    public ChangeUserStatusData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        if (basicUser instanceof Operator) {
            this.permission(basicUser).my(new Permission[]{Permission.MY_OPERATORS_MANAGE_OPERATORS}).user(new Permission[]{Permission.USER_OPERATORS_MANAGE}).check();
        } else {
            this.permission(basicUser).user(new Permission[]{Permission.BLOCKED_USERS_MANAGE, Permission.DISABLED_USERS_VIEW, Permission.REMOVED_USERS_VIEW}).check();
        }
        return this.userStatusService.getData(userLocatorVO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }
}

