/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.UserQuickAccess;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.UserQuickAccessServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessDTO;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.UserQuickAccessService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserQuickAccessServiceSecurity
extends BaseServiceSecurity
implements UserQuickAccessService {
    @Autowired
    private UserQuickAccessServiceLocal userQuickAccessService;

    public UserQuickAccessData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.hasViewPermission(basicUser)) {
            throw new PermissionDeniedException();
        }
        UserQuickAccessData userQuickAccessData = this.userQuickAccessService.getData(userLocatorVO);
        userQuickAccessData.setEditable(this.hasManagePermission(basicUser));
        return userQuickAccessData;
    }

    public void restoreDefaults(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.hasManagePermission(basicUser)) {
            throw new PermissionDeniedException();
        }
        this.userQuickAccessService.restoreDefaults(userLocatorVO);
    }

    public void save(UserLocatorVO userLocatorVO, @NotNull List<UserQuickAccessDTO> list) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        if (!this.hasManagePermission(basicUser)) {
            throw new PermissionDeniedException();
        }
        this.userQuickAccessService.save(userLocatorVO, list);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<UserQuickAccess>(UserQuickAccess.class){

            public boolean isVisible(SessionData sessionData, UserQuickAccess userQuickAccess) {
                return UserQuickAccessServiceSecurity.this.hasViewPermission(userQuickAccess.getUser());
            }
        };
    }

    private boolean hasManagePermission(BasicUser basicUser) {
        return this.permission(basicUser).my(new Permission[]{Permission.MY_QUICK_ACCESS_SETTINGS_ENABLE}).user(new Permission[]{Permission.USER_QUICK_ACCESS_SETTINGS_MANAGE}).granted();
    }

    private boolean hasViewPermission(BasicUser basicUser) {
        return this.permission(basicUser).my(new Permission[]{Permission.MY_QUICK_ACCESS_SETTINGS_ENABLE}).user(new Permission[]{Permission.USER_QUICK_ACCESS_SETTINGS_VIEW}).granted();
    }
}

