/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserImage;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseOwnedImageServiceSecurity;
import org.cyclos.services.users.UserImageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserImageServiceSecurity
extends BaseOwnedImageServiceSecurity<User, UserImage, UserLocatorVO>
implements UserImageService {
    @Autowired
    private UserImageServiceLocal userImageService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;

    public UserImageServiceSecurity() {
        super(UserImage.class, User.class);
    }

    @Override
    public boolean canManageImagesOf(User user) {
        return !user.isRemoved() && this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.EDIT);
    }

    public ImageVO getFirst(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.checkRelatesToUser((IUser)userLocatorVO);
        if (!this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.VIEW)) {
            throw new PermissionDeniedException();
        }
        return this.userImageService.getFirst(userLocatorVO);
    }

    @Override
    protected boolean canListImagesOf(User user) {
        return this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.IMAGE, ProfileFieldAction.VIEW);
    }

    protected UserImageServiceLocal getImplementation() {
        return this.userImageService;
    }
}

