/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.addresses.UserAddressData;
import org.cyclos.model.users.addresses.UserAddressDataParams;
import org.cyclos.model.users.addresses.UserAddressListData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.UserAddressService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserAddressServiceSecurity
extends CRUDServiceSecurity<UserAddressDTO, UserAddress, UserAddressData, UserAddressDataParams>
implements UserAddressService {
    @Autowired
    private UserAddressServiceLocal userAddressService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;

    public UserAddressServiceSecurity() {
        super(UserAddress.class);
    }

    @Override
    public boolean canPerformOperation(UserAddress userAddress, CRUDOperation cRUDOperation) {
        boolean bl = super.canPerformOperation(userAddress, cRUDOperation);
        if (bl && cRUDOperation == CRUDOperation.DELETE) {
            if (this.configurationHandler.getAccessor((BasicUser)userAddress.getUser()).isRequiredAddress()) {
                bl &= userAddress.getUser().getAddresses().size() > 1;
            }
            bl &= this.profileFieldHandler.getFieldActions((BasicUser)userAddress.getUser(), (ProfileField)BasicProfileField.ADDRESS).contains(ProfileFieldAction.EDIT);
        }
        return bl;
    }

    @Override
    public boolean doHasManageAccess(UserAddress userAddress) {
        User user = userAddress.getUser();
        if (user.isRemoved()) {
            return false;
        }
        Set set = this.profileFieldHandler.getFieldActions((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS);
        return set.contains(ProfileFieldAction.EDIT) || set.contains(ProfileFieldAction.MANAGE_PRIVACY);
    }

    @Override
    public boolean doHasViewAccess(UserAddress userAddress) {
        boolean bl = this.profileFieldHandler.isAllowed((BasicUser)userAddress.getUser(), (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.VIEW);
        if (!bl) {
            return false;
        }
        if (userAddress.isHidden()) {
            return this.profileFieldHandler.canViewHidden((BasicUser)userAddress.getUser());
        }
        return this.isRelatedToUser((BasicUser)userAddress.getUser());
    }

    public UserAddressListData getAddressListData(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        Set set = this.profileFieldHandler.getFieldActions((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS);
        PermissionHelper.checkContains((Collection)set, (Object)ProfileFieldAction.VIEW);
        return this.userAddressService.getAddressListData(userLocatorVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, UserAddress userAddress) {
        return false;
    }

    public void markAsDefault(Long l) {
        UserAddress userAddress = (UserAddress)this.find(l);
        this.checkManageAccess(userAddress);
        this.userAddressService.markAsDefault(l);
    }

    @Override
    protected void checkCreateNew(UserAddressDataParams userAddressDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userAddressDataParams.getUser());
        boolean bl = this.profileFieldHandler.isAllowed((BasicUser)user, (ProfileField)BasicProfileField.ADDRESS, ProfileFieldAction.EDIT);
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    protected UserAddressServiceLocal getImplementation() {
        return this.userAddressService;
    }

    @Override
    protected void onBeforeSave(UserAddressDTO userAddressDTO, UserAddress userAddress) {
        Set set = this.profileFieldHandler.getFieldActions((BasicUser)userAddress.getUser(), (ProfileField)BasicProfileField.ADDRESS);
        if (!set.contains(ProfileFieldAction.MANAGE_PRIVACY)) {
            if (userAddressDTO.isTransient()) {
                ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)userAddress.getUser());
                userAddressDTO.setHidden(configurationAccessor.getDefaultAddressPrivacy() == FieldVisibility.HIDDEN);
            } else {
                userAddressDTO.setHidden(userAddress.isHidden());
            }
        }
        if (!set.contains(ProfileFieldAction.EDIT)) {
            this.conversionHandler.fillExcluding((Object)userAddress, (Object)userAddressDTO, new Object[]{UserAddressDTO.HIDDEN, UserAddressDTO.VERSION});
        }
    }
}

