/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.ProductsUserServiceLocal;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.users.products.ActiveProductsData;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserProductsCollections;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.ProductsUserService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ProductsUserServiceSecurity
extends BaseServiceSecurity
implements ProductsUserService {
    @Autowired
    private ProductsUserServiceLocal productsUserService;

    public boolean assign(ProductVO productVO, UserLocatorVO userLocatorVO) throws ValidationException {
        this.checkAssignUnassign(productVO, userLocatorVO);
        return this.productsUserService.assign(productVO, (EntityVO)userLocatorVO);
    }

    public boolean canViewActiveProducts(User user) {
        SessionData sessionData = this.getSessionData();
        return !user.isRemoved() && sessionData.manages((BasicUser)user) && (sessionData.hasPermission(Permission.USERS_ACTIVE_CONFIGURATION_AND_PRODUCTS) || sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW) || sessionData.hasPermission(Permission.PRODUCTS_ASSIGN_TO_USER));
    }

    public ActiveProductsData getActiveProducts(UserLocatorVO userLocatorVO, ChannelVO channelVO, PrincipalTypeVO principalTypeVO) throws FrameworkException {
        this.checkViewActiveProducts(userLocatorVO);
        return this.productsUserService.getActiveProducts((EntityVO)userLocatorVO, channelVO, principalTypeVO);
    }

    public UserProductsCollections getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkPermission(Permission.USER_CONFIGURATION_VIEW, Permission.PRODUCTS_ASSIGN_TO_USER);
        this.checkManagesUser((IUser)userLocatorVO);
        return (UserProductsCollections)this.productsUserService.getData((EntityVO)userLocatorVO);
    }

    public List<ProductAssignmentLogVO> getLogs(@NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkPermission(Permission.USER_CONFIGURATION_VIEW, Permission.PRODUCTS_ASSIGN_TO_USER);
        this.checkManagesUser((IUser)userLocatorVO);
        return this.productsUserService.getLogs((EntityVO)userLocatorVO);
    }

    public boolean unassign(ProductVO productVO, UserLocatorVO userLocatorVO) {
        this.checkAssignUnassign(productVO, userLocatorVO);
        return this.productsUserService.unassign(productVO, (EntityVO)userLocatorVO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkAssignUnassign(ProductVO productVO, UserLocatorVO userLocatorVO) {
        Product product = (Product)this.conversionHandler.convert(Product.class, (Object)productVO);
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        this.permission((BasicUser)user).value((Object)product).user(new Permission[]{Permission.PRODUCTS_ASSIGN_TO_USER}).check();
    }

    private void checkViewActiveProducts(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (!this.canViewActiveProducts(user)) {
            throw new PermissionDeniedException();
        }
    }
}

