/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Collection;
import java.util.Set;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.users.phones.CodeVerificationStatus;
import org.cyclos.model.users.phones.MobilePhoneDTO;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.phones.PhoneData;
import org.cyclos.model.users.phones.PhoneDataParams;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FieldVisibility;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.PhoneService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class PhoneServiceSecurity
extends CRUDServiceSecurity<PhoneDTO, Phone, PhoneData, PhoneDataParams>
implements PhoneService {
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;

    public PhoneServiceSecurity() {
        super(Phone.class);
    }

    @Override
    public boolean canPerformOperation(Phone phone, CRUDOperation cRUDOperation) {
        boolean bl = super.canPerformOperation(phone, cRUDOperation);
        if (bl && cRUDOperation == CRUDOperation.DELETE) {
            boolean bl2;
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(phone.getUser());
            boolean bl3 = bl2 = phone.getNature() == PhoneNature.LANDLINE && configurationAccessor.isLandLineRequired() || phone.getNature() == PhoneNature.MOBILE && configurationAccessor.isMobileRequired();
            if (bl2) {
                bl &= phone.getUser().getPhones().stream().filter(phone2 -> phone2.getNature() == phone.getNature()).count() > 1L;
            }
            bl &= this.profileFieldHandler.getFieldActions(phone.getUser(), (ProfileField)BasicProfileField.PHONE).contains(ProfileFieldAction.EDIT);
        }
        return bl;
    }

    public void disableForSms(PhoneVO phoneVO, String string) throws FrameworkException {
        this.checkIsPhoneOwner(phoneVO);
        this.getImplementation().disableForSms(phoneVO, string);
    }

    @Override
    public boolean doHasManageAccess(Phone phone) {
        BasicUser basicUser = phone.getUser();
        if (basicUser.isRemoved()) {
            return false;
        }
        Set set = this.profileFieldHandler.getFieldActions(basicUser, (ProfileField)BasicProfileField.PHONE);
        return set.contains(ProfileFieldAction.EDIT) || set.contains(ProfileFieldAction.MANAGE_PRIVACY);
    }

    @Override
    public boolean doHasViewAccess(Phone phone) {
        boolean bl = this.profileFieldHandler.isAllowed(phone.getUser(), (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.VIEW);
        if (!bl) {
            return false;
        }
        if (phone.isHidden()) {
            return this.profileFieldHandler.canViewHidden(phone.getUser());
        }
        return this.isRelatedToUser(phone.getUser());
    }

    public void enableForSms(PhoneVO phoneVO) throws FrameworkException {
        this.checkIsPhoneOwner(phoneVO);
        this.getImplementation().enableForSms(phoneVO);
    }

    public CredentialInputDTO getConfirmationPasswordInputForDisableSms(PhoneVO phoneVO) throws FrameworkException {
        this.checkIsPhoneOwner(phoneVO);
        return this.getImplementation().getConfirmationPasswordInputForDisableSms(phoneVO);
    }

    public PhoneListData getPhoneListData(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        Set set = this.profileFieldHandler.getFieldActions(basicUser, (ProfileField)BasicProfileField.PHONE);
        PermissionHelper.checkContains((Collection)set, (Object)ProfileFieldAction.VIEW);
        return this.phoneService.getPhoneListData(userLocatorVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Phone phone) {
        BasicUser basicUser = phone.getUser();
        if (!sessionData.relatesTo(basicUser)) {
            return false;
        }
        if (phone.isHidden()) {
            return this.profileFieldHandler.canViewHidden(basicUser);
        }
        return true;
    }

    public PhoneVO loadByNumber(String string) throws FrameworkException {
        return this.phoneService.loadByNumber(string);
    }

    public String sendVerificationCode(PhoneVO phoneVO) throws FrameworkException {
        this.checkIsPhoneOwner(phoneVO);
        return this.phoneService.sendVerificationCode(phoneVO);
    }

    public CodeVerificationStatus verify(PhoneVO phoneVO, String string) throws FrameworkException {
        this.checkIsPhoneOwner(phoneVO);
        return this.phoneService.verify(phoneVO, string);
    }

    @Override
    protected void checkCreateNew(PhoneDataParams phoneDataParams) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)phoneDataParams.getUser());
        boolean bl = this.profileFieldHandler.isAllowed(basicUser, (ProfileField)BasicProfileField.PHONE, ProfileFieldAction.EDIT);
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    protected PhoneServiceLocal getImplementation() {
        return this.phoneService;
    }

    @Override
    protected void onBeforeSave(PhoneDTO phoneDTO, Phone phone) {
        boolean bl;
        Set set = this.profileFieldHandler.getFieldActions(phone.getUser(), (ProfileField)BasicProfileField.PHONE);
        SessionData sessionData = this.getSessionData();
        if (!set.contains(ProfileFieldAction.MANAGE_PRIVACY)) {
            if (phoneDTO.isTransient()) {
                ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(phone.getUser());
                phoneDTO.setHidden(configurationAccessor.getDefaultPhonePrivacy() == FieldVisibility.HIDDEN);
            } else {
                phoneDTO.setHidden(phone.isHidden());
            }
        }
        if (!(bl = set.contains(ProfileFieldAction.EDIT))) {
            this.conversionHandler.fillExcluding((Object)phone, (Object)phoneDTO, new Object[]{PhoneDTO.HIDDEN, PhoneDTO.VERSION});
        }
        if (phone instanceof MobilePhone) {
            boolean bl2;
            boolean bl3;
            boolean bl4 = sessionData.isAdminOf(phone.getUser()) || sessionData.isBrokerOf(phone.getUser());
            boolean bl5 = phone.getUser().equals((Object)sessionData.getLoggedUser()) && !sessionData.isRestrictedOperator();
            MobilePhone mobilePhone = (MobilePhone)phone;
            MobilePhoneDTO mobilePhoneDTO = (MobilePhoneDTO)phoneDTO;
            boolean bl6 = bl3 = bl4 && bl;
            if (!bl3) {
                mobilePhoneDTO.setVerified(mobilePhone.isVerified());
            }
            boolean bl7 = bl2 = bl3 || bl5 && !sessionData.isRestrictedOperator();
            if (!bl2) {
                mobilePhoneDTO.setEnabledForSms(mobilePhone.isEnabledForSms());
            }
        }
    }

    private MobilePhone checkIsPhoneOwner(PhoneVO phoneVO) {
        MobilePhone mobilePhone = (MobilePhone)this.conversionHandler.convert(MobilePhone.class, (Object)phoneVO);
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = mobilePhone.getUser();
        boolean bl = basicUser.equals((Object)sessionData.getLoggedBasicUser());
        if (!bl && basicUser instanceof Operator) {
            Operator operator = (Operator)basicUser;
            bl = sessionData.isOwnerOf((BasicUser)operator);
        }
        if (!bl) {
            throw new PermissionDeniedException();
        }
        return mobilePhone;
    }
}

