/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import org.cyclos.entities.marketplace.Order;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderParams;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.marketplace.OrderServiceSecurity;
import org.cyclos.services.marketplace.InternalOrderService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InternalOrderServiceSecurity
extends BaseServiceSecurity
implements InternalOrderService {
    @Autowired
    private OrderServiceSecurity orderServiceSecurity;

    public void acceptByBuyer(AcceptOrderParams acceptOrderParams) throws FrameworkException {
        this.accept(acceptOrderParams, false);
    }

    public void acceptBySeller(AcceptOrderParams acceptOrderParams) throws FrameworkException {
        this.accept(acceptOrderParams, true);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void accept(AcceptOrderParams acceptOrderParams, boolean bl) {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)acceptOrderParams.getOrder());
        if (!order.getStatus().equals((Object)(bl ? OrderStatus.PENDING_SELLER : OrderStatus.PENDING_BUYER))) {
            throw new IllegalActionException();
        }
        this.orderServiceSecurity.accept(acceptOrderParams);
    }
}

