/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.LandLinePhone;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.Phone;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserAddress;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.InternalBasicUserServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.users.addresses.UserAddressDTO;
import org.cyclos.model.users.groups.BasicChangeGroupData;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.ChangeGroupData;
import org.cyclos.model.users.operatorgroups.ChangeOperatorGroupDTO;
import org.cyclos.model.users.phones.PhoneDTO;
import org.cyclos.model.users.products.UserBasicFieldActions;
import org.cyclos.model.users.users.AbstractViewProfileData;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserDTO;
import org.cyclos.model.users.users.BasicUserEditProfileData;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.ContactInfoServiceSecurity;
import org.cyclos.security.users.OperatorGroupServiceSecurity;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.security.users.PhoneServiceSecurity;
import org.cyclos.security.users.UserAddressServiceSecurity;
import org.cyclos.security.users.UserGroupServiceSecurity;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.model.users.users.SaveFullProfileData;
import org.cyclos.server.model.users.users.SaveFullProfileParams;
import org.cyclos.server.model.users.users.SaveFullProfileResult;
import org.cyclos.server.model.users.users.UserProfileAddressesData;
import org.cyclos.server.model.users.users.UserProfileContactInfosData;
import org.cyclos.server.model.users.users.UserProfileImagesData;
import org.cyclos.server.model.users.users.UserProfilePhonesData;
import org.cyclos.services.users.InternalBasicUserService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class InternalBasicUserServiceSecurity
extends BaseServiceSecurity
implements InternalBasicUserService {
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private UserAddressServiceSecurity userAddressServiceSecurity;
    @Autowired
    private PhoneServiceSecurity phoneServiceSecurity;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private ContactInfoServiceSecurity contactInfoServiceSecurity;
    @Autowired
    private UserGroupServiceSecurity userGroupServiceSecurity;
    @Autowired
    private OperatorGroupServiceSecurity operatorGroupServiceSecurity;
    @Autowired
    private InternalBasicUserServiceLocal internalBasicUserService;

    public void changeGroup(ChangeGroupDTO changeGroupDTO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changeGroupDTO.getUser());
        if (basicUser.isOperator()) {
            ChangeOperatorGroupDTO changeOperatorGroupDTO = this.internalBasicUserService.toChangeOperatorGroupDTO(changeGroupDTO, basicUser);
            this.operatorGroupServiceSecurity.changeGroup(changeOperatorGroupDTO);
        } else {
            this.userGroupServiceSecurity.changeGroup(changeGroupDTO);
        }
    }

    public BasicChangeGroupData getChangeGroupData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            return this.operatorGroupServiceSecurity.getChangeGroupData(userLocatorVO);
        }
        ChangeGroupData changeGroupData = this.userGroupServiceSecurity.getChangeGroupData(userLocatorVO);
        this.internalBasicUserService.filterGroupSets((BasicChangeGroupData)changeGroupData);
        return changeGroupData;
    }

    public BasicUserEditProfileData<?> getEditData(UserLocatorVO userLocatorVO) {
        this.checkScope(Scope.PROFILE_WRITE);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        this.checkManagesUser(basicUser);
        return this.internalBasicUserService.getEditData(userLocatorVO);
    }

    public SaveFullProfileData getEditFullProfileData(UserLocatorVO userLocatorVO) throws FrameworkException {
        SaveFullProfileData saveFullProfileData;
        block9: {
            UserProfilePhonesData userProfilePhonesData;
            UserProfileAddressesData userProfileAddressesData;
            block8: {
                UserProfileImagesData userProfileImagesData;
                UserProfileContactInfosData userProfileContactInfosData;
                this.checkScope(Scope.PROFILE_WRITE);
                BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
                this.checkManagesUser(basicUser);
                if (basicUser.isRemoved()) {
                    throw new PermissionDeniedException();
                }
                List list = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.EDIT);
                List list2 = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.MANAGE_PRIVACY);
                saveFullProfileData = this.internalBasicUserService.getEditFullProfileData(userLocatorVO);
                CRUDServiceSecurity cRUDServiceSecurity = basicUser.isOperator() ? this.operatorServiceSecurity : this.userServiceSecurity;
                this.setEditable(saveFullProfileData.getUser(), cRUDServiceSecurity);
                userProfileAddressesData = saveFullProfileData.getAddressConfiguration();
                if (userProfileAddressesData != null) {
                    userProfileAddressesData.setEdit(userProfileAddressesData.getMaxAddresses() > 0 && list.contains(BasicProfileField.ADDRESS));
                    userProfileAddressesData.setManagePrivacy(list2.contains(BasicProfileField.ADDRESS));
                }
                if ((userProfilePhonesData = saveFullProfileData.getPhoneConfiguration()) != null) {
                    userProfilePhonesData.setEdit((userProfilePhonesData.getMaxMobiles() > 0 || userProfilePhonesData.getMaxLandLines() > 0) && list.contains(BasicProfileField.PHONE));
                    userProfilePhonesData.setManagePrivacy(list2.contains(BasicProfileField.PHONE));
                }
                if ((userProfileContactInfosData = saveFullProfileData.getContactInfoConfiguration()) != null && basicUser instanceof User) {
                    boolean bl = this.contactInfoServiceSecurity.canManageContactInfosOf((User)basicUser);
                    userProfileContactInfosData.setEdit(bl);
                    userProfileContactInfosData.setManagePrivacy(bl);
                }
                if ((userProfileImagesData = saveFullProfileData.getImageConfiguration()) != null) {
                    userProfileImagesData.setCanManage(list.contains(BasicProfileField.IMAGE));
                }
                if (userProfilePhonesData != null) break block8;
                if (userProfileAddressesData == null) break block9;
            }
            saveFullProfileData.getUser().getProfileFieldActions().stream().filter(UserBasicFieldActions.class::isInstance).map(userProfileFieldActions -> (UserBasicFieldActions)userProfileFieldActions).filter(userBasicFieldActions -> userProfilePhonesData != null && userBasicFieldActions.getBasicField() == BasicProfileField.PHONE || userProfileAddressesData != null && userBasicFieldActions.getBasicField() == BasicProfileField.ADDRESS).forEach(userBasicFieldActions -> userBasicFieldActions.setEdit(userBasicFieldActions.getBasicField() == BasicProfileField.PHONE ? userProfilePhonesData.isEdit() : userProfileAddressesData.isEdit()));
        }
        return saveFullProfileData;
    }

    public Role getMainRole(UserLocatorVO userLocatorVO) throws FrameworkException {
        return this.internalBasicUserService.getMainRole(userLocatorVO);
    }

    public AbstractViewProfileData getViewProfileData(@NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkScope(Scope.PROFILE_READ);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            return this.operatorServiceSecurity.getViewProfileData(userLocatorVO);
        }
        return this.userServiceSecurity.getViewProfileData(userLocatorVO);
    }

    public void remove(UserLocatorVO userLocatorVO) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (basicUser.isOperator()) {
            this.operatorServiceSecurity.checkOperation((Operator)basicUser, CRUDOperation.DELETE);
        } else {
            this.userServiceSecurity.checkOperation((User)basicUser, CRUDOperation.DELETE);
        }
        this.internalBasicUserService.remove(userLocatorVO);
    }

    public void save(UserLocatorVO userLocatorVO, BasicUserDTO basicUserDTO, String string) {
        this.checkScope(Scope.PROFILE_WRITE);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (!this.profileFieldHandler.canEditProfile(basicUser)) {
            throw new PermissionDeniedException();
        }
        this.internalBasicUserService.save(userLocatorVO, basicUserDTO, string);
    }

    public SaveFullProfileResult saveFullProfile(SaveFullProfileParams saveFullProfileParams) throws FrameworkException {
        this.checkScope(Scope.PROFILE_WRITE);
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)saveFullProfileParams.getLocator());
        if (basicUser.isRemoved() || !sessionData.manages(basicUser)) {
            throw new PermissionDeniedException();
        }
        List list = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.EDIT);
        List list2 = this.profileFieldHandler.getFieldsByAction(basicUser, ProfileFieldAction.MANAGE_PRIVACY);
        if (!list.contains(BasicProfileField.PHONE) && (CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getCreateLandLinePhones()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getCreateMobilePhones()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getRemovePhones()))) {
            throw new PermissionDeniedException();
        }
        if (!list.contains(BasicProfileField.PHONE) && !list2.contains(BasicProfileField.PHONE) && (CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getModifyLandLinePhones()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getModifyMobilePhones()))) {
            throw new PermissionDeniedException();
        }
        CollectionHelper.orEmpty((List)saveFullProfileParams.getModifyLandLinePhones()).forEach(landLinePhoneDTO -> this.phoneServiceSecurity.onBeforeSave((PhoneDTO)landLinePhoneDTO, (Phone)this.find(LandLinePhone.class, landLinePhoneDTO.getId())));
        CollectionHelper.orEmpty((List)saveFullProfileParams.getModifyMobilePhones()).forEach(mobilePhoneDTO -> this.phoneServiceSecurity.onBeforeSave((PhoneDTO)mobilePhoneDTO, (Phone)this.find(MobilePhone.class, mobilePhoneDTO.getId())));
        if (!list.contains(BasicProfileField.ADDRESS) && (CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getCreateAddresses()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getRemoveAddresses()))) {
            throw new PermissionDeniedException();
        }
        if (!list.contains(BasicProfileField.ADDRESS) && !list2.contains(BasicProfileField.ADDRESS) && CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getModifyAddresses())) {
            throw new PermissionDeniedException();
        }
        CollectionHelper.orEmpty((List)saveFullProfileParams.getModifyAddresses()).forEach(userAddressDTO -> this.userAddressServiceSecurity.onBeforeSave((UserAddressDTO)userAddressDTO, this.find(UserAddress.class, userAddressDTO.getId())));
        if (!list.contains(BasicProfileField.IMAGE) && (CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getAddImages()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getRemoveImages()))) {
            throw new PermissionDeniedException();
        }
        if (!this.contactInfoServiceSecurity.canManageContactInfosOf(basicUser.getUser()) && (CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getCreateContactInfos()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getModifyContactInfos()) || CollectionHelper.isNotEmpty((Iterable)saveFullProfileParams.getRemoveContactInfos()))) {
            throw new PermissionDeniedException();
        }
        return this.internalBasicUserService.saveFullProfile(saveFullProfileParams);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private <E extends BasicUser> void setEditable(BasicUserEditProfileData<?> basicUserEditProfileData, CRUDServiceSecurity<?, E, ?, ?> cRUDServiceSecurity) {
        if (basicUserEditProfileData == null) {
            return;
        }
        BasicUser basicUser = (BasicUser)cRUDServiceSecurity.find(basicUserEditProfileData.getDto().getId());
        boolean bl = cRUDServiceSecurity.canPerformOperation(basicUser, CRUDOperation.UPDATE);
        basicUserEditProfileData.setEditable(bl);
    }
}

