/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.Set;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.GroupServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.configurations.ActiveConfigurationForGroupsData;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.users.groups.AdminGroupData;
import org.cyclos.model.users.groups.BasicGroupDTO;
import org.cyclos.model.users.groups.BasicGroupData;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupQuery;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.GroupSearchData;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.ProductServiceSecurity;
import org.cyclos.services.users.GroupService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class GroupServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<BasicGroupDTO, BasicGroup, BasicGroupData, BasicGroupNature>
implements GroupService {
    @Autowired
    private GroupServiceLocal groupService;
    @Autowired
    private ProductServiceSecurity productServiceSecurity;

    public GroupServiceSecurity() {
        super(BasicGroup.class);
    }

    @Override
    public boolean canPerformOperation(BasicGroup basicGroup, CRUDOperation cRUDOperation) {
        if (cRUDOperation == CRUDOperation.DELETE) {
            return this.hasPermission(Permission.USER_CONFIGURATION_MANAGE);
        }
        return super.canPerformOperation(basicGroup, cRUDOperation);
    }

    public void changeConfiguration(BasicGroupVO basicGroupVO, ConfigurationVO configurationVO) throws FrameworkException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        if (!this.hasManageAccess(basicGroup)) {
            throw new PermissionDeniedException();
        }
        this.groupService.changeConfiguration(basicGroupVO, configurationVO);
    }

    @Override
    public boolean doHasViewAccess(BasicGroup basicGroup) {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW) || sessionData.hasPermission(Permission.ACCESSIBLE_GROUPS_VIEW) && this.isAccessible(basicGroup);
    }

    public ActiveConfigurationForGroupsData getActiveConfiguration(BasicGroupVO basicGroupVO) throws EntityNotFoundException {
        BasicGroup basicGroup = (BasicGroup)this.conversionHandler.convert(BasicGroup.class, (Object)basicGroupVO);
        this.checkViewAccess(basicGroup);
        return this.groupService.getActiveConfiguration(basicGroupVO);
    }

    public GroupSearchData getSearchData() {
        boolean bl;
        SessionData sessionData = this.getSessionData();
        boolean bl2 = bl = sessionData.hasPermission(Permission.USER_CONFIGURATION_VIEW) || sessionData.hasPermission(Permission.ACCESSIBLE_GROUPS_VIEW);
        if (!bl) {
            throw new PermissionDeniedException();
        }
        boolean bl3 = sessionData.hasPermission(Permission.USER_CONFIGURATION_MANAGE);
        GroupSearchData groupSearchData = this.groupService.getSearchData();
        groupSearchData.setCanCreateNew(bl3);
        groupSearchData.setCanRemove(bl3);
        return groupSearchData;
    }

    public Page<BasicGroupVO> search(BasicGroupQuery basicGroupQuery) {
        this.checkPermission(Permission.USER_CONFIGURATION_VIEW, Permission.ACCESSIBLE_GROUPS_VIEW);
        return this.groupService.search(basicGroupQuery);
    }

    @Override
    protected void checkCreateNew(BasicGroupNature basicGroupNature) {
        this.checkPermission(Permission.USER_CONFIGURATION_MANAGE);
    }

    @Override
    protected void customizeData(BasicGroupData basicGroupData) {
        if (basicGroupData instanceof AdminGroupData) {
            AdminGroupData adminGroupData = (AdminGroupData)basicGroupData;
            if (((BasicGroupDTO)basicGroupData.getDto()).isPersistent()) {
                AdminGroup adminGroup = this.find(AdminGroup.class, ((BasicGroupDTO)basicGroupData.getDto()).getId());
                adminGroupData.setCanViewProduct(this.productServiceSecurity.hasViewAccess(adminGroup.getAdminProduct()));
                adminGroupData.setCanManageProduct(this.productServiceSecurity.hasManageAccess(adminGroup.getAdminProduct()));
            }
        }
    }

    @Override
    protected boolean doHasManageAccess(BasicGroup basicGroup) {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.USER_CONFIGURATION_MANAGE) || sessionData.hasPermission(Permission.ACCESSIBLE_GROUPS_MANAGE) && this.isAccessible(basicGroup);
    }

    protected GroupServiceLocal getImplementation() {
        return this.groupService;
    }

    private boolean isAccessible(BasicGroup basicGroup) {
        Set set = this.groupsHandler.accessibles().basic().items();
        boolean bl = set.contains(basicGroup);
        if (!bl && basicGroup instanceof UserGroup) {
            bl = set.contains(((UserGroup)basicGroup).getGroupSet());
        }
        return bl;
    }
}

