/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.GeneralReference;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.references.GeneralReferenceDTO;
import org.cyclos.model.users.references.GeneralReferenceData;
import org.cyclos.model.users.references.GeneralReferenceDataParams;
import org.cyclos.model.users.references.GeneralReferenceEntryVO;
import org.cyclos.model.users.references.GeneralReferenceQuery;
import org.cyclos.model.users.references.GeneralReferenceSearchData;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.services.users.GeneralReferenceService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class GeneralReferenceServiceSecurity
extends CRUDServiceSecurity<GeneralReferenceDTO, GeneralReference, GeneralReferenceData, GeneralReferenceDataParams>
implements GeneralReferenceService {
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;
    @Autowired
    private UserServiceSecurity userServiceSecurity;

    public GeneralReferenceServiceSecurity() {
        super(GeneralReference.class);
    }

    @Override
    public boolean doHasManageAccess(GeneralReference generalReference) {
        try {
            this.check(generalReference.getFrom(), generalReference.getTo());
            return true;
        }
        catch (IllegalActionException | PermissionDeniedException throwable) {
            return false;
        }
    }

    @Override
    public boolean doHasViewAccess(GeneralReference generalReference) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = this.canManage((BasicUser)generalReference.getFrom()) || this.canManage((BasicUser)generalReference.getTo());
        boolean bl4 = bl = generalReference.getFrom().equals((Object)this.getLoggedUser()) || generalReference.getTo().equals((Object)this.getLoggedUser());
        bl2 = bl ? this.hasPermission(Permission.MY_REFERENCES_RECEIVE, Permission.MY_REFERENCES_GIVE) : (this.isMember() && !bl3 ? this.hasPermission(Permission.MY_REFERENCES_VIEW) : this.hasPermission(Permission.USER_REFERENCES_MANAGE) && bl3);
        return (this.isRelatedToUser((BasicUser)generalReference.getTo()) || this.isRelatedToUser((BasicUser)generalReference.getFrom())) && bl2;
    }

    public GeneralReferenceSearchData getSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (user == null || !this.userServiceSecurity.canViewProfile(user)) {
            throw new PermissionDeniedException();
        }
        GeneralReferenceSearchData generalReferenceSearchData = this.generalReferenceService.getSearchData(userLocatorVO);
        generalReferenceSearchData.setEditable(this.permission((BasicUser)user).user(new Permission[]{Permission.USER_REFERENCES_MANAGE}).my(new Permission[]{Permission.MY_REFERENCES_GIVE}).granted());
        ArrayList<ReferenceType> arrayList = new ArrayList<ReferenceType>();
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member();
        if (memberProductAccessor.hasPermission(Permission.MY_REFERENCES_GIVE)) {
            arrayList.add(ReferenceType.GIVEN);
        }
        if (memberProductAccessor.hasPermission(Permission.MY_REFERENCES_RECEIVE)) {
            arrayList.add(ReferenceType.RECEIVED);
        }
        generalReferenceSearchData.setDirections(arrayList);
        if (arrayList.size() == 1) {
            ((GeneralReferenceQuery)generalReferenceSearchData.getQuery()).setReferenceType((ReferenceType)CollectionHelper.first(arrayList));
        } else {
            ((GeneralReferenceQuery)generalReferenceSearchData.getQuery()).setReferenceType(ReferenceType.RECEIVED);
        }
        generalReferenceSearchData.setCanSetReference(!user.isRemoved() && this.hasPermission(Permission.MY_REFERENCES_GIVE) && arrayList.contains(ReferenceType.RECEIVED));
        return generalReferenceSearchData;
    }

    public ReferenceStatisticsVO getStatistics(@NotNull ReferenceStatisticsParams referenceStatisticsParams) throws FrameworkException {
        this.checkView(referenceStatisticsParams.getOwner());
        return this.generalReferenceService.getStatistics(referenceStatisticsParams);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, GeneralReference generalReference) {
        return false;
    }

    public Page<GeneralReferenceEntryVO> search(GeneralReferenceQuery generalReferenceQuery) {
        this.checkView(generalReferenceQuery.getOwner());
        return this.generalReferenceService.search(generalReferenceQuery);
    }

    protected void check(User user, User user2) {
        if (user2 != null && !this.productsHandler.getAccessor((BasicUser)user2).product().hasPermission(Permission.MY_REFERENCES_RECEIVE)) {
            throw new IllegalActionException();
        }
        this.permission((BasicUser)user).user(new Permission[]{Permission.USER_REFERENCES_MANAGE}).my(new Permission[]{Permission.MY_REFERENCES_GIVE}).check();
    }

    @Override
    protected void checkCreateNew(GeneralReferenceDataParams generalReferenceDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)generalReferenceDataParams.getToUser());
        User user2 = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)generalReferenceDataParams.getFromUser());
        this.check(user2, user);
    }

    protected GeneralReferenceServiceLocal getImplementation() {
        return this.generalReferenceService;
    }

    @Override
    protected void onBeforeSave(GeneralReferenceDTO generalReferenceDTO, GeneralReference generalReference) {
        generalReferenceDTO.setDate(null);
    }

    private User checkView(UserLocatorVO userLocatorVO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        boolean bl = false;
        boolean bl2 = this.canManage((BasicUser)user);
        boolean bl3 = user.equals((Object)this.getLoggedUser());
        if (bl3) {
            bl = this.hasPermission(Permission.MY_REFERENCES_RECEIVE, Permission.MY_REFERENCES_GIVE);
        } else if (this.isMember() && !bl2) {
            bl = this.hasPermission(Permission.MY_REFERENCES_VIEW);
        } else {
            boolean bl4 = bl = this.hasPermission(Permission.USER_REFERENCES_MANAGE) && bl2;
        }
        if (!bl) {
            throw new PermissionDeniedException();
        }
        return user;
    }
}

