/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import com.querydsl.core.types.Path;
import java.util.Collection;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.users.BulkAction;
import org.cyclos.entities.users.BulkActionUser;
import org.cyclos.entities.users.ChangeFieldValueBulkAction;
import org.cyclos.entities.users.ChangeStatusBulkAction;
import org.cyclos.entities.users.CustomOperationBulkAction;
import org.cyclos.entities.users.QProductUserProfileField;
import org.cyclos.entities.users.QUserProductPasswordAction;
import org.cyclos.entities.users.ResetPasswordBulkAction;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.users.bulkactions.AppMailingBulkActionDTO;
import org.cyclos.model.users.bulkactions.BulkActionDTO;
import org.cyclos.model.users.bulkactions.BulkActionData;
import org.cyclos.model.users.bulkactions.BulkActionDataParams;
import org.cyclos.model.users.bulkactions.BulkActionDetailsData;
import org.cyclos.model.users.bulkactions.BulkActionNature;
import org.cyclos.model.users.bulkactions.BulkActionQuery;
import org.cyclos.model.users.bulkactions.BulkActionSearchUsersData;
import org.cyclos.model.users.bulkactions.BulkActionStatusVO;
import org.cyclos.model.users.bulkactions.BulkActionUsage;
import org.cyclos.model.users.bulkactions.BulkActionUserQuery;
import org.cyclos.model.users.bulkactions.BulkActionUserVO;
import org.cyclos.model.users.bulkactions.BulkActionVO;
import org.cyclos.model.users.bulkactions.BulkActionsSearchData;
import org.cyclos.model.users.bulkactions.EmailMailingBulkActionDTO;
import org.cyclos.model.users.bulkactions.MailingListPreviewData;
import org.cyclos.model.users.bulkactions.SendSMSResult;
import org.cyclos.model.users.bulkactions.SmsMailingBulkActionDTO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.BulkActionService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class BulkActionServiceSecurity
extends CRUDServiceSecurity<BulkActionDTO, BulkAction, BulkActionData, BulkActionDataParams>
implements BulkActionService {
    @Autowired
    private BulkActionServiceLocal bulkActionService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private UserStatusServiceLocal userStatusService;

    public BulkActionServiceSecurity() {
        super(BulkAction.class);
    }

    public int cancel(Long l) throws FrameworkException {
        BulkAction bulkAction = (BulkAction)this.find(l);
        this.checkManageAccess(bulkAction);
        return this.bulkActionService.cancel(l);
    }

    @Override
    public boolean canPerformOperation(BulkAction bulkAction, CRUDOperation cRUDOperation) {
        switch (cRUDOperation) {
            case READ: 
            case DELETE: {
                return super.canPerformOperation(bulkAction, cRUDOperation);
            }
            case UPDATE: {
                return false;
            }
            case CREATE: {
                return this.canRun(bulkAction);
            }
        }
        return false;
    }

    @Override
    public boolean doHasViewAccess(BulkAction bulkAction) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker() && !sessionData.isSelf(bulkAction.getBy())) {
            return false;
        }
        return this.hasPermission(bulkAction.getNature().getUsage(), false);
    }

    public String getErrorStackTrace(Long l) throws FrameworkException {
        BulkActionUser bulkActionUser = this.find(BulkActionUser.class, l);
        this.checkViewAccess(bulkActionUser.getBulkAction());
        return this.bulkActionService.getErrorStackTrace(l);
    }

    public BulkActionsSearchData getSearchData(BulkActionUsage bulkActionUsage) throws FrameworkException {
        BulkActionsSearchData bulkActionsSearchData = this.bulkActionService.getSearchData(bulkActionUsage);
        switch (bulkActionUsage) {
            case GENERAL: {
                this.checkPermission(Permission.BULK_ACTIONS_VIEW);
                bulkActionsSearchData.getRunBuiltIn().removeIf(bulkActionNature -> !this.canRun((BulkActionNature)bulkActionNature));
                Set set = SimpleEntity.uniqueIds((Collection)this.customOperationService.getRunnableOperationsForBulkActions());
                bulkActionsSearchData.getRunCustomOperations().removeIf(customOperationVO -> !set.contains(customOperationVO.getId()));
                break;
            }
            case MAILING_LIST: {
                this.checkPermission(Permission.MAILINGS_VIEW);
            }
        }
        return bulkActionsSearchData;
    }

    public BulkActionSearchUsersData getSearchUsersData(BulkActionDataParams bulkActionDataParams) throws FrameworkException {
        this.checkCreateNew(bulkActionDataParams);
        return this.bulkActionService.getSearchUsersData(bulkActionDataParams);
    }

    public BulkActionStatusVO getStatus(Long l) throws FrameworkException {
        BulkAction bulkAction = (BulkAction)this.find(l);
        this.checkViewAccess(bulkAction);
        return this.bulkActionService.getStatus(l);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, BulkAction bulkAction) {
        return false;
    }

    public MailingListPreviewData previewMailingList(@NotNull BulkActionDTO bulkActionDTO, UserVO userVO) throws FrameworkException {
        this.checkPermission(Permission.MAILINGS_MANAGE);
        return this.bulkActionService.previewMailingList(bulkActionDTO, userVO);
    }

    public Page<BulkActionVO> search(BulkActionQuery bulkActionQuery) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        BulkActionUsage bulkActionUsage = bulkActionQuery.getUsage();
        if (bulkActionUsage == null) {
            throw new ValidationException();
        }
        if (!this.hasPermission(bulkActionUsage, false)) {
            throw new PermissionDeniedException();
        }
        if (sessionData.isBroker()) {
            bulkActionQuery.setBy(new UserVO(sessionData.getLoggedUser().getId()));
        }
        return this.bulkActionService.search(bulkActionQuery);
    }

    public Page<BulkActionUserVO> searchUsers(BulkActionUserQuery bulkActionUserQuery) throws FrameworkException {
        BulkAction bulkAction = (BulkAction)this.conversionHandler.convert(BulkAction.class, (Object)bulkActionUserQuery.getBulkAction());
        this.checkViewAccess(bulkAction);
        this.checkVO(User.class, (EntityVO)bulkActionUserQuery.getUser());
        this.groupsHandler.visibles().users().basic().check((Collection)bulkActionUserQuery.getGroups());
        return this.bulkActionService.searchUsers(bulkActionUserQuery);
    }

    public boolean sendTestApp(AppMailingBulkActionDTO appMailingBulkActionDTO, UserVO userVO, UserVO userVO2) throws FrameworkException {
        this.checkPermission(Permission.MAILINGS_MANAGE);
        return this.bulkActionService.sendTestApp(appMailingBulkActionDTO, userVO, userVO2);
    }

    public boolean sendTestEmail(EmailMailingBulkActionDTO emailMailingBulkActionDTO, UserVO userVO, String string) {
        this.checkPermission(Permission.MAILINGS_MANAGE);
        return this.bulkActionService.sendTestEmail(emailMailingBulkActionDTO, userVO, string);
    }

    public SendSMSResult sendTestSms(SmsMailingBulkActionDTO smsMailingBulkActionDTO, UserVO userVO, String string) {
        this.checkPermission(Permission.MAILINGS_MANAGE);
        return this.bulkActionService.sendTestSms(smsMailingBulkActionDTO, userVO, string);
    }

    @Override
    protected void checkCreateNew(BulkActionDataParams bulkActionDataParams) {
        BulkActionNature bulkActionNature = bulkActionDataParams.getNature();
        boolean bl = bulkActionNature == BulkActionNature.CUSTOM_OPERATION ? this.canRun(bulkActionDataParams.getCustomOperation()) : this.canRun(bulkActionNature);
        if (!bl) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(BulkActionData bulkActionData) {
        BulkActionDetailsData bulkActionDetailsData;
        if (bulkActionData instanceof BulkActionDetailsData && (bulkActionDetailsData = (BulkActionDetailsData)bulkActionData).isCanCancel()) {
            BulkAction bulkAction = (BulkAction)this.find(((BulkActionDTO)bulkActionData.getDto()).getId());
            bulkActionDetailsData.setCanCancel(this.hasManageAccess(bulkAction));
        }
    }

    @Override
    protected boolean doHasManageAccess(BulkAction bulkAction) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.relatesTo(bulkAction.getBy())) {
            return false;
        }
        return this.hasPermission(bulkAction.getNature().getUsage(), true);
    }

    @Override
    protected CRUDServiceLocal<BulkAction, BulkActionDTO, BulkActionData, BulkActionDataParams> getImplementation() {
        return this.bulkActionService;
    }

    @Override
    protected void onBeforeSave(BulkActionDTO bulkActionDTO, BulkAction bulkAction) {
        super.onBeforeSave(bulkActionDTO, bulkAction);
        SessionData sessionData = this.getSessionData();
        if (sessionData.isBroker() && bulkActionDTO.getQuery() != null) {
            bulkActionDTO.getQuery().setBrokers(Set.of(new UserVO(sessionData.getLoggedUser().getId())));
        }
    }

    private boolean canRun(BulkAction bulkAction) {
        BulkActionDataParams bulkActionDataParams = new BulkActionDataParams();
        bulkActionDataParams.setNature(bulkAction.getNature());
        if (bulkAction instanceof CustomOperationBulkAction) {
            CustomOperation customOperation = ((CustomOperationBulkAction)bulkAction).getCustomOperation();
            return this.canRun(new CustomOperationVO(customOperation.getId()));
        }
        if (!this.canRun(bulkAction.getNature())) {
            return false;
        }
        if (bulkAction instanceof ChangeStatusBulkAction) {
            ChangeStatusBulkAction changeStatusBulkAction = (ChangeStatusBulkAction)bulkAction;
            return this.userStatusService.getManagedStatuses().contains(changeStatusBulkAction.getNewStatus());
        }
        if (bulkAction instanceof ResetPasswordBulkAction) {
            ResetPasswordBulkAction resetPasswordBulkAction = (ResetPasswordBulkAction)bulkAction;
            PasswordType passwordType = resetPasswordBulkAction.getPasswordType();
            QUserProductPasswordAction qUserProductPasswordAction = QUserProductPasswordAction.userProductPasswordAction;
            return this.getProducts().userManagement().getUserPasswordActions().get((Object)passwordType).isSet((Path)qUserProductPasswordAction.reset);
        }
        if (bulkAction instanceof ChangeFieldValueBulkAction) {
            ChangeFieldValueBulkAction changeFieldValueBulkAction = (ChangeFieldValueBulkAction)bulkAction;
            UserCustomField userCustomField = changeFieldValueBulkAction.getCustomField();
            QProductUserProfileField qProductUserProfileField = QProductUserProfileField.productUserProfileField;
            return this.getProducts().userManagement().getUserProfileFields().get((Object)userCustomField).isSet((Path)qProductUserProfileField.editable);
        }
        return true;
    }

    private boolean canRun(BulkActionNature bulkActionNature) {
        SessionData sessionData = this.getSessionData();
        if (bulkActionNature == null) {
            return false;
        }
        if (bulkActionNature.getUsage() == BulkActionUsage.MAILING_LIST) {
            return sessionData.hasPermission(Permission.MAILINGS_MANAGE);
        }
        if (!sessionData.hasPermission(Permission.BULK_ACTIONS_MANAGE)) {
            return false;
        }
        switch (bulkActionNature) {
            case CHANGE_GROUP: {
                return sessionData.hasPermission(Permission.USER_GROUP_MANAGE);
            }
            case CHANGE_STATUS: {
                return CollectionHelper.isNotEmpty((Iterable)this.userStatusService.getManagedStatuses());
            }
            case RESET_PASSWORD: {
                return sessionData.hasPermission(Permission.USER_PASSWORDS_MANAGE);
            }
            case REINDEX: {
                if (!sessionData.isAdmin()) {
                    return false;
                }
                return sessionData.getProducts().userManagement().getUserProfileFields().isAnyKeySet((Path)QProductUserProfileField.productUserProfileField.editable);
            }
            case CHANGE_FIELD_VALUE: {
                Set set = sessionData.getProducts().userManagement().getUserProfileFields().keysSet((Path)QProductUserProfileField.productUserProfileField.editable);
                return set.stream().filter(UserCustomField.class::isInstance).findAny().isPresent();
            }
        }
        return false;
    }

    private boolean canRun(CustomOperationVO customOperationVO) {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.hasPermission(Permission.BULK_ACTIONS_MANAGE) || customOperationVO == null) {
            return false;
        }
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
        return this.customOperationService.getRunnableOperationsForBulkActions().contains(customOperation);
    }

    private boolean hasPermission(BulkActionUsage bulkActionUsage, boolean bl) {
        Permission permission = null;
        switch (bulkActionUsage) {
            case GENERAL: {
                permission = bl ? Permission.BULK_ACTIONS_MANAGE : Permission.BULK_ACTIONS_VIEW;
                break;
            }
            case MAILING_LIST: {
                permission = bl ? Permission.MAILINGS_MANAGE : Permission.MAILINGS_VIEW;
            }
        }
        return this.hasPermission(permission);
    }
}

