/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.users;

import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Brokering;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.brokering.AddBrokerData;
import org.cyclos.model.users.brokering.BrokeringData;
import org.cyclos.model.users.brokering.BrokeringWithUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.users.BrokeringService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class BrokeringServiceSecurity
extends BaseServiceSecurity
implements BrokeringService {
    @Autowired
    private BrokeringServiceLocal brokeringService;

    public Long addBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2, boolean bl) throws FrameworkException, IllegalActionException {
        this.checkManage(userLocatorVO);
        return this.brokeringService.addBroker(userLocatorVO, userLocatorVO2, bl);
    }

    public AddBrokerData getAddBrokerData(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkManage(userLocatorVO);
        return this.brokeringService.getAddBrokerData(userLocatorVO);
    }

    public BrokeringWithUserVO getByUserAndBroker(@NotNull UserLocatorVO userLocatorVO, @NotNull UserLocatorVO userLocatorVO2) throws FrameworkException {
        this.checkView(userLocatorVO);
        return this.brokeringService.getByUserAndBroker(userLocatorVO, userLocatorVO2);
    }

    public BrokeringData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkView(userLocatorVO);
        BrokeringData brokeringData = this.brokeringService.getData(userLocatorVO);
        brokeringData.setEditable(this.canManageBrokerings((User)this.conversionHandler.convert(User.class, (Object)userLocatorVO)));
        return brokeringData;
    }

    public void removeBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws IllegalActionException {
        this.checkManage(userLocatorVO);
        this.brokeringService.removeBroker(userLocatorVO, userLocatorVO2);
    }

    public void setMainBroker(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws FrameworkException, IllegalActionException {
        this.checkManage(userLocatorVO);
        this.brokeringService.setMainBroker(userLocatorVO, userLocatorVO2);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Brokering>(Brokering.class){

            public boolean isVisible(SessionData sessionData, Brokering brokering) {
                return BrokeringServiceSecurity.this.canViewBrokerings(brokering.getUser());
            }
        };
    }

    private boolean canManageBrokerings(User user) {
        return this.permission((BasicUser)user).user(new Permission[]{Permission.USER_BROKER_MANAGE}).granted();
    }

    private boolean canViewBrokerings(User user) {
        return this.permission((BasicUser)user).user(new Permission[]{Permission.USER_BROKER_VIEW}).granted();
    }

    private void checkManage(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (!this.canManageBrokerings(user)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        if (!this.canViewBrokerings(user)) {
            throw new PermissionDeniedException();
        }
    }
}

