/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.ServiceInterceptor;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ServiceInterceptorServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.interceptors.ServiceInterceptorDTO;
import org.cyclos.model.system.interceptors.ServiceInterceptorData;
import org.cyclos.model.system.interceptors.ServiceInterceptorVO;
import org.cyclos.model.system.networks.NetworkVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.NetworkServiceSecurity;
import org.cyclos.services.system.ServiceInterceptorService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ServiceInterceptorServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<ServiceInterceptorDTO, ServiceInterceptor, ServiceInterceptorData, Void>
implements ServiceInterceptorService {
    @Autowired
    private ServiceInterceptorServiceLocal serviceInterceptorService;
    @Autowired
    private NetworkServiceSecurity networkServiceSecurity;

    public ServiceInterceptorServiceSecurity() {
        super(ServiceInterceptor.class);
    }

    public void disableAllInterceptorsInNetwork(NetworkVO networkVO) throws FrameworkException {
        if (this.getSessionData().getNetwork() != null) {
            throw new PermissionDeniedException();
        }
        Network network = (Network)this.conversionHandler.convert(Network.class, (Object)networkVO);
        if (!this.networkServiceSecurity.hasManageAccess(network)) {
            throw new PermissionDeniedException();
        }
        this.serviceInterceptorService.disableAllInterceptorsInNetwork(networkVO);
    }

    @Override
    public boolean doHasViewAccess(ServiceInterceptor serviceInterceptor) {
        return this.canView();
    }

    public List<ServiceInterceptorVO> list() throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.serviceInterceptorService.list();
    }

    public void saveOrder(List<Long> list) throws FrameworkException {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
        this.serviceInterceptorService.saveOrder(list);
    }

    @Override
    protected void checkCreateNew(Void void_) {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected boolean doHasManageAccess(ServiceInterceptor serviceInterceptor) {
        return this.canManage();
    }

    @Override
    protected CRUDServiceLocal<ServiceInterceptor, ServiceInterceptorDTO, ServiceInterceptorData, Void> getImplementation() {
        return this.serviceInterceptorService;
    }

    private boolean canManage() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) && sessionData.getNetwork() != null;
    }

    private boolean canView() {
        SessionData sessionData = this.getSessionData();
        return sessionData.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW) && sessionData.getNetwork() != null;
    }
}

