/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.ProfilingServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.profiling.ProfilingData;
import org.cyclos.model.system.profiling.ProfilingSessionVO;
import org.cyclos.model.system.profiling.StartProfilingParams;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.ProfilingService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class ProfilingServiceSecurity
extends BaseServiceSecurity
implements ProfilingService {
    @Autowired
    private ProfilingServiceLocal profilingService;

    public ProfilingSessionVO getCurrent() throws FrameworkException {
        this.check();
        return this.profilingService.getCurrent();
    }

    public ProfilingData getData() throws FrameworkException {
        this.check();
        return this.profilingService.getData();
    }

    public List<ProfilingSessionVO> list() {
        this.check();
        return this.profilingService.list();
    }

    public ProfilingSessionVO load(@NotNull Long l) throws FrameworkException {
        this.check();
        return this.profilingService.load(l);
    }

    public String readData(@NotNull Long l) throws FrameworkException {
        this.check();
        return this.profilingService.readData(l);
    }

    public void remove(Long l) throws FrameworkException {
        this.check();
        this.profilingService.remove(l);
    }

    public int removeAll() throws FrameworkException {
        this.check();
        return this.profilingService.removeAll();
    }

    public void start(StartProfilingParams startProfilingParams) throws FrameworkException {
        this.check();
        this.profilingService.start(startProfilingParams);
    }

    public ProfilingSessionVO stop() throws FrameworkException {
        this.check();
        return this.profilingService.stop();
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void check() {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return;
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (basicUser == null || !basicUser.isGlobalAdmin()) {
            throw new PermissionDeniedException();
        }
    }
}

