/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.LocalizationServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.model.utils.TimeZoneVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.LocalizationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class LocalizationServiceSecurity
extends BaseServiceSecurity
implements LocalizationService {
    @Autowired
    private LocalizationServiceLocal localizationService;

    public List<CountryVO> listCountries() throws FrameworkException {
        return this.localizationService.listCountries();
    }

    public List<TimeZoneVO> listTimeZones() throws FrameworkException {
        this.check();
        return this.localizationService.listTimeZones();
    }

    public List<TimeZoneVO> listTimeZonesByCountry(String string) throws FrameworkException {
        this.check();
        return this.localizationService.listTimeZonesByCountry(string);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void check() {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isAdmin() && !sessionData.isSystem()) {
            throw new PermissionDeniedException();
        }
    }
}

