/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomOperationAction;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomOperationActionServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.system.operations.CustomOperationActionDTO;
import org.cyclos.model.system.operations.CustomOperationActionData;
import org.cyclos.model.system.operations.CustomOperationActionDataParams;
import org.cyclos.model.system.operations.CustomOperationActionVO;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.CustomOperationServiceSecurity;
import org.cyclos.services.system.CustomOperationActionService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomOperationActionServiceSecurity
extends CRUDServiceSecurity<CustomOperationActionDTO, CustomOperationAction, CustomOperationActionData, CustomOperationActionDataParams>
implements CustomOperationActionService {
    @Autowired
    private CustomOperationActionServiceLocal customOperationActionService;
    @Autowired
    private CustomOperationServiceSecurity customOperationServiceSecurity;

    public CustomOperationActionServiceSecurity() {
        super(CustomOperationAction.class);
    }

    @Override
    public boolean doHasViewAccess(CustomOperationAction customOperationAction) {
        return this.canView();
    }

    @Override
    public boolean isAccessible(SessionData sessionData, CustomOperationAction customOperationAction) {
        return true;
    }

    public List<CustomOperationActionVO> list(CustomOperationVO customOperationVO) throws FrameworkException {
        if (!this.canView()) {
            throw new PermissionDeniedException();
        }
        return this.customOperationActionService.list(customOperationVO);
    }

    public void saveOrder(List<Long> list) throws FrameworkException {
        if (!this.canManage()) {
            throw new PermissionDeniedException();
        }
        this.customOperationActionService.saveOrder(list);
    }

    @Override
    protected void checkCreateNew(CustomOperationActionDataParams customOperationActionDataParams) {
        this.customOperationServiceSecurity.checkCreateNew(null);
    }

    @Override
    protected boolean doHasManageAccess(CustomOperationAction customOperationAction) {
        return this.canManage();
    }

    @Override
    protected CRUDServiceLocal<CustomOperationAction, CustomOperationActionDTO, CustomOperationActionData, CustomOperationActionDataParams> getImplementation() {
        return this.customOperationActionService;
    }

    private boolean canManage() {
        return this.customOperationServiceSecurity.canManage();
    }

    private boolean canView() {
        return this.customOperationServiceSecurity.canView();
    }
}

